function Separador(x) {//SEPARADOR CON DECIMAL
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

$('document').ready(function(){
   $("#checkTodos").change(function () {
      $("input:checkbox").prop('checked', $(this).prop("checked"));
  });
});


//FUNCION PARA LIMPIAR CAMPOS DE INSCRIPCIONES
function LimpiarInscripciones(){
$("#inscripciones")[0].reset(); 
$("#muestracampomonto").html("");
$("#muestraforpagos").html("");
$("#error").html("");
}

// FUNCION PARA LIMPIAR CHECKBOX ACTIVOS
function LimpiarCheckbox(){
$("input[type='checkbox']:checked:enabled").attr('checked',false);
$("#cargacheckbox").html("");
}


////////////////////////////////////////////// FUNCIONES PARA PROCESAR DATOS ///////////////////////////////////////////






function CargarMesPago(codnivel){

$('#muestracampomonto').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'MuestraCampoMesPago=si&codnivel='+codnivel;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#muestracampomonto').empty();
      $('#muestracampomonto').append(''+response+'').fadeIn("slow");
    }
  });
}


//FUNCION PARA MOSTRAR FORMULARIO DE PAGOS EN INSCRIPCION DE ESTUDIANTES
function ActivaPagos(montopago,becado){

$('#muestraforpagos').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaFormularioPagos=si&montopago='+montopago+"&becado="+becado;

$.ajax({
            type: "GET",
            url: "funciones.php",
            data: dataString,
            success: function(response) {            
                $('#muestraforpagos').empty();
                $('#muestraforpagos').append(''+response+'').fadeIn("slow");

           }
      });
}










// FUNCION PARA MOSTRAR PERIODO ESCOLAR EN VENTANA MODAL
function VerPeriodo(codperiodo){

$('#muestraperiodomodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaPeriodoModal=si&codperiodo='+codperiodo;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestraperiodomodal').empty();
        $('#muestraperiodomodal').append(''+response+'').fadeIn("slow");

      }
  });
}

// FUNCION PARA ACTUALIZAR PERIODO ESCOLAR
function UpdatePeriodo(codperiodo) {

  swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Actualizar este Periodo Escolar?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Actualizar",
          confirmButtonColor: "#3085d6"
        }, function(isConfirm) {
    if (isConfirm) {
      location.href = "forperiodo?codperiodo="+codperiodo;
      // handle confirm
    } else {
      // handle all other cases
    }
  })
}


/////FUNCION PARA ELIMINAR PERIODO ESCOLAR 
function EliminarPeriodo(codperiodo,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Periodo Escolar?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codperiodo="+codperiodo+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#periodos").load("consultas.php?CargaPeriodosEscolares=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Periodo Escolar no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Periodo Escolar, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}










/////////////////////////////////// FUNCIONES DE MEDIOS DE PAGOS //////////////////////////////////////

// FUNCION PARA ACTUALIZAR MEDIOS DE PAGOS
function UpdateMedio(codmediopago,mediopago,proceso) 
{
    // aqui asigno cada valor a los campos correspondientes
  $("#savemedios #codmediopago").val(codmediopago);
  $("#savemedios #mediopago").val(mediopago);
  $("#savemedios #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR MEDIOS DE PAGOS 
function EliminarMedio(codmediopago,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Medio de Pago?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codmediopago="+codmediopago+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $('#mediospagos').load("consultas?CargaMediosPagos=si");
                  
          } else if(data==2){ 

             swal("Oops", "Este Medio de Pago no puede ser Eliminado, tiene Pagos relacionados!", "error"); 

          } else { 

             swal("Oops", "Usted no tiene Acceso para Eliminar Medios de Pagos, no eres el Administrador del Sistema!", "error"); 

                }
            }
        })
    });
}










// FUNCION PARA ACTUALIZAR TURNOS
function UpdateTurno(codturno,turno,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#saveturno #codturno").val(codturno);
  $("#saveturno #turno").val(turno);
  $("#saveturno #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR TURNOS 
function EliminarTurno(codturno,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Turno?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codturno="+codturno+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#turnos").load("consultas.php?CargaTurnos=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Turno no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Turnos, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}








// FUNCION PARA ACTUALIZAR NIVELES
function UpdateNivel(codnivel,nivel,pagonivel,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savenivel #codnivel").val(codnivel);
  $("#savenivel #nivel").val(nivel);
  $("#savenivel #pagonivel").val(pagonivel);
  $("#savenivel #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR NIVELES 
function EliminarNivel(codnivel,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Nivel?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codnivel="+codnivel+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#niveles").load("consultas.php?CargaNiveles=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Nivel no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Niveles, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}







// FUNCION PARA ACTUALIZAR GRADOS
function UpdateGrado(codgrado,codnivel,grado,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savegrado #codgrado").val(codgrado);
  $("#savegrado #codnivel").val(codnivel);
  $("#savegrado #grado").val(grado);
  $("#savegrado #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR GRADOS 
function EliminarGrado(codgrado,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Grado?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codgrado="+codgrado+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#grados").load("consultas.php?CargaGrados=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Grado no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Grados, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

////FUNCION PARA MOSTRAR GRADOS POR NIVEL
function CargarGrados(codnivel){

//$('#codgrado').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');      
var dataString = 'BuscaGrados=si&codnivel='+codnivel;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#codgrado').empty();
      $('#codgrado').append(''+response+'').fadeIn("slow");
    }
  });
}

////FUNCION PARA MOSTRAR GRADOS POR NIVEL
function SelectGrado(codnivel,codgrado){

  $("#codgrado").load("funciones.php?SeleccionaGrado=si&codnivel="+codnivel+"&codgrado="+codgrado);

}







// FUNCION PARA ACTUALIZAR SECCION
function UpdateSeccion(codseccion,codnivel,seccion,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#saveseccion #codseccion").val(codseccion);
  $("#saveseccion #codnivel").val(codnivel);
  $("#saveseccion #seccion").val(seccion);
  $("#saveseccion #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR SECCION 
function EliminarSeccion(codseccion,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar esta Seccion?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codseccion="+codseccion+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#secciones").load("consultas.php?CargaSecciones=si");
                  
          } else if(data==2){ 

              swal("Oops", "Esta Seccion no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Secciones, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

////FUNCION PARA MOSTRAR SECCIONES POR GRADOS
function CargarSecciones(codgrado){

//$('#codseccion').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaSecciones=si&codgrado='+codgrado;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#codseccion').empty();
      $('#codseccion').append(''+response+'').fadeIn("slow");
    }
  });
}







// FUNCION PARA ACTUALIZAR AREAS
function UpdateArea(codarea,nomarea,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savearea #codarea").val(codarea);
  $("#savearea #nomarea").val(nomarea);
  $("#savearea #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR AREAS 
function EliminarArea(codarea,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar esta Área?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codarea="+codarea+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#areas").load("consultas.php?CargaAreas=si");
                  
          } else if(data==2){ 

              swal("Oops", "Esta Área no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Áreas, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}






// FUNCION PARA MOSTRAR MATERIA EN VENTANA MODAL
function VerMateria(codmateria){

$('#muestramateriamodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');

var dataString = 'BuscaMateriaModal=si&codmateria='+codmateria;

$.ajax({
            type: "GET",
      url: "funciones.php",
            data: dataString,
            success: function(response) {            
                $('#muestramateriamodal').empty();
                $('#muestramateriamodal').append(''+response+'').fadeIn("slow");

            }
      });
}

// FUNCION PARA ACTUALIZAR MATERIAS
function UpdateMateria(codmateria,codarea,nommateria,codnivel,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savemateria #codmateria").val(codmateria);
  $("#savemateria #codarea").val(codarea);
  $("#savemateria #nommateria").val(nommateria);
  $("#savemateria #codnivel").val(codnivel);
  $("#savemateria #proceso").val(proceso);
}


/////FUNCION PARA ELIMINAR MATERIAS 
function EliminarMateria(codmateria,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar esta Materia?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codmateria="+codmateria+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#materias").load("consultas.php?CargaMaterias=si");
                  
          } else if(data==2){ 

              swal("Oops", "Esta Materia no puede ser Eliminada, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Materias, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

//FUNCION PARA BUSQUEDA DE MATERIAS POR NIVEL Y GRADOS
function BuscarMateriasxGrado(){
                  
$('#muestramaterias').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var dataString = $("#busquedamaterias").serialize();
var url = 'funciones.php?BuscarMateriasxGrado=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
    success: function(response) {            
        $('#muestramaterias').empty();
        $('#muestramaterias').append(''+response+'').fadeIn("slow");
        }
    }); 
}

////FUNCION PARA MOSTRAR MATERIAS POR GRADOS
function CargarMaterias(codgrado){

//$('#codmateria').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaMaterias=si&codgrado='+codgrado;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#codmateria').empty();
      $('#codmateria').append(''+response+'').fadeIn("slow");
    }
  });
}

////FUNCION PARA MOSTRAR MATERIAS POR DOCENTES
function CargarMateriasxDocente(codturno,codnivel,codgrado,codseccion){

//$('#codmateria').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaMateriasxDocente=si&codturno='+codturno+"&codnivel="+codnivel+"&codgrado="+codgrado+"&codseccion="+codseccion;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#codmateria').empty();
      $('#codmateria').append(''+response+'').fadeIn("slow");
    }
  });
}











// FUNCION PARA MOSTRAR USUARIOS EN VENTANA MODAL
function VerUsuario(codigo){

$('#muestrausuariomodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');

var dataString = 'BuscaUsuarioModal=si&codigo='+codigo;

$.ajax({
    type: "GET",
	url: "funciones.php",
    data: dataString,
        success: function(response) {            
            $('#muestrausuariomodal').empty();
            $('#muestrausuariomodal').append(''+response+'').fadeIn("slow");
        }
    });
}

// FUNCION PARA ACTUALIZAR USUARIOS
function UpdateUsuario(codigo,cedula,nombres,telefono,sexo,cargo,email,usuario,nivel,status,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#saveusuario #codigo").val(codigo);
  $("#saveusuario #cedula").val(cedula);
  $("#saveusuario #nombres").val(nombres);
  $("#saveusuario #telefono").val(telefono);
  $("#saveusuario #sexo").val(sexo);
  $("#saveusuario #cargo").val(cargo);
  $("#saveusuario #email").val(email);
  $("#saveusuario #usuario").val(usuario);
  $("#saveusuario #nivel").val(nivel);
  $("#saveusuario #status").val(status);
  $("#saveusuario #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR USUARIOS 
function EliminarUsuario(codigo,cedula,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Usuario?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codigo="+codigo+"&cedula="+cedula+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#usuarios").load("consultas.php?CargaUsuarios=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Usuario no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Usuarios, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}













// FUNCION PARA MOSTRAR CAJA EN VENTANA MODAL
function VerCaja(codcaja){

$('#muestracajamodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaCajaModal=si&codcaja='+codcaja;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestracajamodal').empty();
        $('#muestracajamodal').append(''+response+'').fadeIn("slow");
      }
  });
}

// FUNCION PARA ACTUALIZAR CAJAS
function UpdateCaja(codcaja,nrocaja,nombrecaja,codigo,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savecaja #codcaja").val(codcaja);
  $("#savecaja #nrocaja").val(nrocaja);
  $("#savecaja #nombrecaja").val(nombrecaja);
  $("#savecaja #codigo").val(codigo);
  $("#savecaja #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR CAJAS 
function EliminarCaja(codcaja,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar esta Caja?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codcaja="+codcaja+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#cajas").load("consultas.php?CargaCajas=si");
                  
          } else if(data==2){ 

              swal("Oops", "Esta Caja no puede ser Eliminada, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Cajas, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}










// FUNCION PARA MOSTRAR ARQUEOS EN VENTANA MODAL
function VerArqueo(codarqueo){

$('#muestraarqueomodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaArqueoModal=si&codarqueo='+codarqueo;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestraarqueomodal').empty();
        $('#muestraarqueomodal').append(''+response+'').fadeIn("slow");
      }
  });
}

// FUNCION PARA CERRAR ARQUEOS
function CerrarArqueo(codarqueo,proceso) {

  swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Cerrar este Arqueo de Caja?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Continuar",
          confirmButtonColor: "#3085d6"
        }, function(isConfirm) {
    if (isConfirm) {
      location.href = "forcierre?codarqueo="+codarqueo+"&proceso="+proceso;
      // handle confirm
    } else {
      // handle all other cases
    }
  })
}

// FUNCION PARA CERRAR ARQUEO DE CAJA
function ActualizarArqueo(codarqueo,proceso) {

  swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Actualizar este Arqueo de Caja?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Continuar",
          confirmButtonColor: "#3085d6"
        }, function(isConfirm) {
    if (isConfirm) {
      location.href = "forcierre?codarqueo="+codarqueo+"&proceso="+proceso;
      // handle confirm
    } else {
      // handle all other cases
    }
  })
}

//FUNCION PARA CALCULAR LA DIFERENCIA EN CIERRE DE CAJA
$(document).ready(function (){
    $('.cierrecaja').keyup(function (){
      
    var efectivo = $('input#dineroefectivo').val();
    var estimado = $('input#estimado').val();
            
    //REALIZO EL CALCULO Y MUESTRO LA DEVOLUCION
    total=efectivo - estimado;
    var original=parseFloat(total.toFixed(2));
    $("#diferencia").val(original.toFixed(2));/**/
      
    });
});

//FUNCION PARA BUSQUEDA DE ARQUEOS DE CAJAS POR FECHAS PARA REPORTES
function BuscarArqueosxFechas(){
                  
$('#muestraarqueosxfechas').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codcaja = $("#codcaja").val();
var desde = $("input#desde").val();
var hasta = $("input#hasta").val();
var dataString = $("#arqueosxfechas").serialize();
var url = 'funciones.php?BuscaArqueosxFechas=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
      success: function(response) {            
        $('#muestraarqueosxfechas').empty();
        $('#muestraarqueosxfechas').append(''+response+'').fadeIn("slow");
      }
  }); 
}















// FUNCION PARA MOSTRAR MOVIMIENTO EN CAJA EN VENTANA MODAL
function VerMovimiento(numero){

$('#muestramovimientomodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');

var dataString = 'BuscaMovimientoModal=si&numero='+numero;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestramovimientomodal').empty();
        $('#muestramovimientomodal').append(''+response+'').fadeIn("slow");
      }
  });
}

// FUNCION PARA ACTUALIZAR MOVIMIENTOS EN CAJAS
function UpdateMovimiento(codmovimiento,numero,codarqueo,codcaja,tipomovimiento,nrorecibo,descripcionmovimiento,montomovimiento,fechamovimiento,proceso) 
{
    // aqui asigno cada valor a los campos correspondientes
  $("#savemovimiento #codmovimiento").val(codmovimiento);
  $("#savemovimiento #numero").val(numero);
  $("#savemovimiento #codarqueo").val(codarqueo);
  $("#savemovimiento #codcaja").val(codcaja);
  $("#savemovimiento #tipomovimiento").val(tipomovimiento);
  $("#savemovimiento #tipomovimientobd").val(tipomovimiento);
  $("#savemovimiento #nrorecibo").val(nrorecibo);
  $("#savemovimiento #descripcionmovimiento").val(descripcionmovimiento);
  $("#savemovimiento #montomovimiento").val(montomovimiento);
  $("#savemovimiento #montomovimientobd").val(montomovimiento);
  $("#savemovimiento #fecharegistro").val(fechamovimiento);
  $("#savemovimiento #proceso").val(proceso);
}

/////FUNCION PARA ELIMINAR MOVIMIENTO EN CAJA 
function EliminarMovimiento(codmovimiento,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Movimiento en Caja?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codmovimiento="+codmovimiento+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#movimientos").load("consultas.php?CargaMovimientos=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Movimiento no puede ser Eliminado, La Apertura asociada se encuentra Cerrada!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Movimientos, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

//FUNCION PARA BUSQUEDA DE MOVIMIENTOS DE CAJAS POR FECHAS PARA REPORTES
function BuscarMovimientosxFechas(){
                  
$('#muestramovimientosxfechas').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codcaja = $("#codcaja").val();
var desde = $("input#desde").val();
var hasta = $("input#hasta").val();
var dataString = $("#movimientosxfechas").serialize();
var url = 'funciones.php?BuscaMovimientosxFechas=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
      success: function(response) {            
        $('#muestramovimientosxfechas').empty();
        $('#muestramovimientosxfechas').append(''+response+'').fadeIn("slow");
      }
  }); 
}













// FUNCION PARA MOSTRAR DOCENTES EN VENTANA MODAL
function VerDocente(coddoc){

$('#muestradocentemodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');

var dataString = 'BuscaDocenteModal=si&coddoc='+coddoc;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestradocentemodal').empty();
        $('#muestradocentemodal').append(''+response+'').fadeIn("slow");
      }
  });
}

// FUNCION PARA ACTUALIZAR DOCENTES
function UpdateDocente(coddoc,ceddoc,nomdoc,tlfdoc,direcdoc,especdoc,fecnacdoc,edocivildoc,lugarnacdoc,correodoc,expedido,horasdoc,codcargodoc,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#savedocente #coddoc").val(coddoc);
  $("#savedocente #ceddoc").val(ceddoc);
  $("#savedocente #nomdoc").val(nomdoc);
  $("#savedocente #tlfdoc").val(tlfdoc);
  $("#savedocente #direcdoc").val(direcdoc);
  $("#savedocente #especdoc").val(especdoc);
  $("#savedocente #fecnacdoc").val(fecnacdoc);
  $("#savedocente #edocivildoc").val(edocivildoc);
  $("#savedocente #lugarnacdoc").val(lugarnacdoc);
  $("#savedocente #correodoc").val(correodoc);
  $("#savedocente #expedido").val(expedido);
  $("#savedocente #horasdoc").val(horasdoc);
  $("#savedocente #codcargodoc").val(codcargodoc);
  $("#savedocente #proceso").val(proceso);
}

/////FUNCION PARA REINICIAR DOCENTES 
function ReiniciarDocente(coddoc,ceddoc,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Reiniciar la Clave de Acceso de este Docente?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Reiniciar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "coddoc="+coddoc+"&ceddoc="+ceddoc+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Clave Reiniciada!", "La Clave de Acceso fue reiniciada con éxito!", "success");
            $("#docentes").load("consultas.php?CargaDocentes=si");
                  
          } else {

             swal("Oops", "Usted no tiene Acceso para Reiniciar Claves de Docentes, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

/////FUNCION PARA ELIMINAR DOCENTES 
function EliminarDocente(coddoc,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Docente?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "coddoc="+coddoc+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#docentes").load("consultas.php?CargaDocentes=si");
                  
          } else if(data==2){ 

              swal("Oops", "Este Docente no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Docentes, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}











//FUNCION PARA REGISTRAR ASIGNACION DE CURSOS
function BuscaDocente(){
                  
$('#muestradocente').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var coddoc = $("#coddoc").val();
var dataString = $("#asignaciones").serialize();
var url = 'funciones.php?CrearAsignacion=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
      success: function(response) {            
        $('#muestradocente').empty();
        $('#muestradocente').append(''+response+'').fadeIn("slow");
      }
  }); 
}

////FUNCION PARA MOSTRAR MATERIAS POR GRADOS
function BuscarMaterias(codturno,codnivel,codgrado,codseccion){

$('#muestra_materias').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaMateriasxGrado=si&codturno='+codturno+"&codnivel="+codnivel+"&codgrado="+codgrado+"&codseccion="+codseccion;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
    success: function(response) {            
      $('#muestra_materias').empty();
      $('#muestra_materias').append(''+response+'').fadeIn("slow");
    }
  });
}

//FUNCION PARA LIMPIAR CAMPOS EN ASIGNACION DE CURSOS
function LimpiarAsignacion()
{   
   $("#coddoc").val("");
   $("#search_docente").val("");
   $("#codturno").val("");
   $("#codnivel").val("");
   $('#codgrado').html("<option value=''>SIN RESULTADOS</option>");
   $('#codseccion').html("<option value=''>SIN RESULTADOS</option>");
   $("#muestra_materias").html("");
   $('#myModalAsignacion').modal('hide');
}

// FUNCION PARA MOSTRAR ASIGNACIONES DE CURSOS EN VENTANA MODAL
function VerAsignacion(codasignacion){

$('#muestraasignacionmodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');

var dataString = 'BuscaAsignacionModal=si&codasignacion='+codasignacion;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
      success: function(response) {            
        $('#muestraasignacionmodal').empty();
        $('#muestraasignacionmodal').append(''+response+'').fadeIn("slow");
      }
  });
}

/////FUNCION PARA ELIMINAR ASIGNACIONES DE CURSOS 
function EliminarAsignacion(codasignacion,coddoc,codmateria,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar esta Asignación de Curso?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codasignacion="+codasignacion+"&coddoc="+coddoc+"&codmateria="+codmateria+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#asignaciones").load("consultas.php?CargaAsignaciones=si");
                  
          } else if(data==2){ 

              swal("Oops", "Esta Asignación de Curso no puede ser Eliminado, tiene registros relacionados!", "error"); 

          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Asignaciones de Cursos, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

//FUNCION PARA BUSQUEDA DE ASIGNACIONES DE CURSOS
function BuscarAsignacionMateriasReportes(){
                  
$('#muestraasignaciones').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var coddoc = $("#coddoc").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#reporteasignaciones").serialize();
var url = 'funciones.php?BuscaAsignacionMateriasReportes=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
      success: function(response) {            
        $('#muestraasignaciones').empty();
        $('#muestraasignaciones').append(''+response+'').fadeIn("slow");
      }
  }); 
}











//FUNCION PARA REGISTRAR INSCRIPCION DE ESTUDIANTES
function BuscaEstudiante(){
    
$('#muestraestudiante').html('<center><img src="assets/images/loading.gif" width="30" height="30"/></center>');
var cedula = $("#cedula").val();
var dataString = $("#inscripciones").serialize();
var url = 'funciones.php?CrearEstudiante=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {
            $('#muestraestudiante').empty();
            $('#muestraestudiante').append(''+response+'').fadeIn("slow");
        }
    }); 
}

//FUNCION PARA BUSQUEDA CONTROL DE ESTUDIANTES
function BusquedaControlEstudiantes(){
                  
$('#muestraestudiantes').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var dataString = $("#busquedaestudiantes").serialize();
var url = 'funciones.php?BusquedaControlEstudiantes=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {            
        $('#muestraestudiantes').empty();
        $('#muestraestudiantes').append(''+response+'').fadeIn("slow");
        }
    }); 
}


// FUNCION PARA MOSTRAR ESTUDIANTE EN VENTANA MODAL
function VerEstudiante(codest){

$('#muestraestudiantemodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaEstudianteModal=si&codest='+codest;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
        success: function(response) {            
            $('#muestraestudiantemodal').empty();
            $('#muestraestudiantemodal').append(''+response+'').fadeIn("slow");
        }
    });
}

// FUNCION PARA ACTUALIZAR DATOS DE ESTUDIANTES DE VENTANA MODAL
function UpdateEstudiante(codest,cedest,pnomest,snomest,papeest,sapeest,sexoest,direcest,fnacest,proceso) 
{
  // do anything you want here
  $("#updateestudiante #codest").val(codest);
  $("#updateestudiante #cedest").val(cedest);
  $("#updateestudiante #pnomest").val(pnomest);
  $("#updateestudiante #snomest").val(snomest);
  $("#updateestudiante #papeest").val(papeest);
  $("#updateestudiante #sapeest").val(sapeest);
  $("#updateestudiante #sexoest").val(sexoest);
  $("#updateestudiante #direcest").val(direcest);
  $("#updateestudiante #fnacest").val(fnacest);
  $("#retiroestudiante #proceso").val(proceso);
};

// FUNCION PARA RETIRAR ESTUDIANTES DE VENTANA MODAL
function RetiraEstudiante(codpadre,codest,codperiodo,cedest,pnomest,papeest,proceso) 
{
  // do anything you want here
  $("#retiroestudiante #codpadre").val(codpadre);
  $("#retiroestudiante #codest").val(codest);
  $("#retiroestudiante #codperiodo").val(codperiodo);
  $("#retiroestudiante #cedest").val(cedest);
  $("#retiroestudiante #nombres").val(pnomest);
  $("#retiroestudiante #apellidos").val(papeest);
  $("#retiroestudiante #proceso").val(proceso);
};

/////FUNCION PARA REINICIAR ESTUDIANTES 
function ReiniciarEstudiante(codest,cedest,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Reiniciar la Clave de Acceso de este Estudiante?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Reiniciar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codest="+codest+"&cedest="+cedest+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Clave Reiniciada!", "La Clave de Acceso fue reiniciada con éxito!", "success");
            $("#BotonBusqueda").trigger("click");
                  
          } else {

             swal("Oops", "Usted no tiene Acceso para Reiniciar Claves de Estudiantes, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

/////FUNCION PARA ELIMINAR ESTUDIANTE
function EliminarEstudiante(codpadre,codest,tipo) {
        swal({
          title: "¿Estás seguro?", 
          text: "¿Estás seguro de Eliminar este Estudiante, Se eliminaran todos los registros asociados a este?", 
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "Cancelar",
          cancelButtonColor: '#d33',
          closeOnConfirm: false,
          confirmButtonText: "Eliminar",
          confirmButtonColor: "#3085d6"
        }, function() {
             $.ajax({
                  type: "GET",
                  url: "eliminar.php",
                  data: "codpadre="+codpadre+'&codest='+codest+"&tipo="+tipo,
                  success: function(data){

          if(data==1){

            swal("Eliminado!", "Datos eliminados con éxito!", "success");
            $("#BotonBusqueda").trigger("click");
                  
          } else {

             swal("Oops", "Usted no tiene Acceso para Eliminar Estudiantes, no eres el Administrador del Sistema!", "error"); 
             
                }

            }
        })
    });
}

//FUNCION PARA BUSQUEDA DE ESTUDIANTES PARA REPORTES
function BuscarEstudiantesxCursos(){
                  
$('#muestraestudiantes').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var dataString = $("#estudiantesxcursos").serialize();
var url = 'funciones.php?BuscaEstudiantesxCursos=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestraestudiantes').empty();
                $('#muestraestudiantes').append(''+response+'').fadeIn("slow");
               }
      }); 
}












// FUNCION PARA MOSTRAR TUTORES EN VENTANA MODAL
function VerTutor(codpadre){

$('#muestratutormodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaTutorModal=si&codpadre='+codpadre;

$.ajax({
    type: "GET",
    url: "funciones.php",
    data: dataString,
        success: function(response) {            
            $('#muestratutormodal').empty();
            $('#muestratutormodal').append(''+response+'').fadeIn("slow");
        }
    });
}

// FUNCION PARA ACTUALIZAR TUTORES
function UpdateTutor(codpadre,cedpadre,nompadre,apepadre,tlfpadre,proceso) 
{
  // aqui asigno cada valor a los campos correspondientes
  $("#updatetutor #codpadre").val(codpadre);
  $("#updatetutor #cedulapadre").val(cedpadre);
  $("#updatetutor #cedant").val(cedpadre);
  $("#updatetutor #nompadre").val(nompadre);
  $("#updatetutor #apepadre").val(apepadre);
  $("#updatetutor #tlfpadre").val(tlfpadre);
  $("#updatetutor #proceso").val(proceso);
}


//FUNCION PARA BUSQUEDA DE TUTORES POR CURSOS
function BuscarTutoresxCursos(){
                  
$('#muestratutores').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var dataString = $("#busquedatutores").serialize();
var url = 'funciones.php?BuscaTutoresxCursos=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
      success: function(response) {            
        $('#muestratutores').empty();
        $('#muestratutores').append(''+response+'').fadeIn("slow");
      }
  }); 
}









//FUNCION PARA CALCULAR DESCUENTO EN INSCRIPCIONES
function CalcularDescInscripcion()
{
    var desc = $('input#descuento').val();
    desc2  = desc/100;
    var total = $('input#textSubtotal').val();
    var mora = $('input#montomora').val();
    var inscripcion = $('input#montoinscripcion').val();
    var unica = $('input#cuotaunica').val();
    var montomesextra = $('input#montomesextra').val();

    //CALCULO DEL TOTAL DE FACTURA
    TotalDescuentoGeneral = total * desc2;
    TotalFactura = total - TotalDescuentoGeneral;
          
    var original=parseFloat(TotalFactura);
    var original2=parseFloat(TotalFactura) + parseFloat(inscripcion) + parseFloat(unica) + parseFloat(montomesextra);

    $("#txtdescuento").text(Separador(TotalDescuentoGeneral.toFixed(2)));
    $("#txttotal").text(Separador(original2.toFixed(2))); 
    $("#txtDescuento").val(TotalDescuentoGeneral.toFixed(2));
    $("#txtTotal").val(original2.toFixed(2)); 
}

// FUNCION PARA MOSTRAR PAGOS EN VENTANA MODAL
function VerPago(numcomprobante){

$('#muestrapagosmodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaPagoModal=si&numcomprobante='+numcomprobante;

$.ajax({
            type: "GET",
            url: "funciones.php",
            data: dataString,
            success: function(response) {            
                $('#muestrapagosmodal').empty();
                $('#muestrapagosmodal').append(''+response+'').fadeIn("slow");

           }
      });
}

//FUNCION PARA BUSQUEDA DE PAGOS
function BuscarPagosxEstudiantes(){
                  
$('#muestrapagosxestudiantes').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#controlpagos").serialize();
var url = 'funciones.php?BuscarPagosxEstudiante=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestrapagosxestudiantes').empty();
                $('#muestrapagosxestudiantes').append(''+response+'').fadeIn("slow");
               }
      }); 
}

//FUNCION PARA BUSQUEDA DE COMPROBANTES DE PAGOS
function BuscarComprobantePagos(){
                  
$('#muestracomprobantespagos').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#comprobantespagos").serialize();
var url = 'funciones.php?BuscaComprobantesReportes=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestracomprobantespagos').empty();
                $('#muestracomprobantespagos').append(''+response+'').fadeIn("slow");
               }
      }); 
}

//FUNCION PARA BUSQUEDA DE PAGOS GENERALES
function BuscarPagosxFechas(){
                  
$('#muestradetalles').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var desde = $("#desde").val();
var hasta = $("#hasta").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#pagosxfechas").serialize();
var url = 'funciones.php?BuscaPagosxFechas=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {            
            $('#muestradetalles').empty();
            $('#muestradetalles').append(''+response+'').fadeIn("slow");
        }
    }); 
}

//FUNCION PARA BUSQUEDA DE PAGOS AL DIA
function BuscarPagosxDia(){
                  
$('#muestradetalles').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var mespago = $("#mespago").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#pagosaldia").serialize();
var url = 'funciones.php?BuscaPagosxDia=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {            
            $('#muestradetalles').empty();
            $('#muestradetalles').append(''+response+'').fadeIn("slow");
        }
    }); 
}

//FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS
function BuscarPagosVencidosxCursos(){
                  
$('#muestradetalles').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#pagosvencidos").serialize();
var url = 'funciones.php?BuscaPagosVencidosxCursos=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {            
            $('#muestradetalles').empty();
            $('#muestradetalles').append(''+response+'').fadeIn("slow");
        }
    }); 
}

//FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS
function BuscarPagosVencidosxPeriodo(){
                  
$('#muestradetalles').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#pagosvencidos").serialize();
var url = 'funciones.php?BuscaPagosVencidosxPeriodo=si';

$.ajax({
    type: "GET",
    url: url,
    data: dataString,
        success: function(response) {            
            $('#muestradetalles').empty();
            $('#muestradetalles').append(''+response+'').fadeIn("slow");
        }
    }); 
}













//FUNCION PARA BUSQUEDA DE ESTUDIANTES DE NOTAS
function BuscarEstudiantesNotas(){
                  
$('#muestraestudiantesnotas').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var codmateria = $("#codmateria").val();
var dataString = $("#notas").serialize();
var url = 'funciones.php?BuscaEstudiantesNotas=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestraestudiantesnotas').empty();
                $('#muestraestudiantesnotas').append(''+response+'').fadeIn("slow");
               }
      }); 
}

//FUNCION PARA BUSQUEDA DE ESTUDIANTES NUEVAS NOTAS
function BuscaEstudianteNuevaNota(){
                  
$('#muestraestudiantenuevanota').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var dataString = $("#nuevasnotas").serialize();
var url = 'funciones.php?BuscaEstudiantesNuevaNota=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestraestudiantenuevanota').empty();
                $('#muestraestudiantenuevanota').append(''+response+'').fadeIn("slow");
                $("#muestramateriasnotas").html("");
               }
      }); 
}

// FUNCION PARA MOSTRAR NOTAS EN VENTANA MODAL
function VerificaNuevaNota(codest,codseccion,codturno,codperiodo){

$('#muestramateriasnotas').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BusquedaNuevaNota=si&codest='+codest+"&codseccion="+codseccion+"&codturno="+codturno+"&codperiodo="+codperiodo;

$.ajax({
            type: "GET",
            url: "funciones.php",
            data: dataString,
            success: function(response) {            
                $('#muestramateriasnotas').empty();
                $('#muestramateriasnotas').append(''+response+'').fadeIn("slow");

           }
      });
}

// FUNCION PARA MOSTRAR NOTAS EN VENTANA MODAL
function VerNota(codnota){

$('#muestranotamodal').html('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando información ......</center>');
                
var dataString = 'BuscaNotasModal=si&codnota='+codnota;

$.ajax({
            type: "GET",
            url: "funciones.php",
            data: dataString,
            success: function(response) {            
                $('#muestranotamodal').empty();
                $('#muestranotamodal').append(''+response+'').fadeIn("slow");

           }
      });
}

//FUNCION PARA BUSQUEDA DE BOLETIN DE NOTAS
function BuscarNotas(){
                  
$('#muestranotas').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var dataString = $("#boletinescolar").serialize();
var url = 'funciones.php?BuscaNotas=si&c=d';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestranotas').empty();
                $('#muestranotas').append(''+response+'').fadeIn("slow");
               }
      }); 
}

//FUNCION PARA BUSQUEDA DE NOTAS POR CURSOS
function BuscarNotasxCursos(){
                  
$('#muestranotasxcursos').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codturno = $("#codturno").val();
var codnivel = $("#codnivel").val();
var codgrado = $("#codgrado").val();
var codseccion = $("#codseccion").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#notasxcursos").serialize();
var url = 'funciones.php?BuscaNotasxCursos=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestranotasxcursos').empty();
                $('#muestranotasxcursos').append(''+response+'').fadeIn("slow");
               }
      }); 
}

//FUNCION PARA BUSQUEDA DE NOTAS POR PERIODO
function BuscarNotasxPeriodos(){
                  
$('#muestranotasxperiodos').html('<center><i class="fa fa-spin fa-spinner"></i> Procesando información, por favor espere....</center>');

var codest = $("#codest").val();
var codperiodo = $("#codperiodo").val();
var dataString = $("#notasxperiodos").serialize();
var url = 'funciones.php?BuscaNotasxPeriodos=si';

$.ajax({
            type: "GET",
            url: url,
            data: dataString,
            success: function(response) {            
                $('#muestranotasxperiodos').empty();
                $('#muestranotasxperiodos').append(''+response+'').fadeIn("slow");
               }
      }); 
}