# +===================================================================
# | Generado el 01-09-2023 a las 13:28:50 
# | Servidor: localhost
# | MySQL Version: 5.5.5-10.4.21-MariaDB
# | PHP Version: 8.0.12
# | Base de datos: 'softacademico'
# | Tablas: areas;  arqueocaja;  asignaciones;  cajas;  configuracion;  contador_cuotas;  definitivas;  detallespagos;  docentes;  estudiantes;  grados;  log;  materias;  mediospagos;  mediospagoxpagos;  movimientoscajas;  niveles;  notas;  padres;  pagos;  periodoescolar;  secciones;  turnos;  usuarios
# +-------------------------------------------------------------------
# Si tienen tablas con relacion y no estan en orden dara problemas al recuperar datos. Para evitarlo:
SET FOREIGN_KEY_CHECKS=0; 
SET time_zone = '+00:00';
SET sql_mode = ''; 


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

# | Vaciado de tabla 'areas'
# +-------------------------------------
DROP TABLE IF EXISTS `areas`;


# | Estructura de la tabla 'areas'
# +-------------------------------------
CREATE TABLE `areas` (
  `codarea` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nomarea` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codarea`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'areas'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `areas` (`codarea`, `nomarea`) VALUES 
      ('AR001', 'EDUC PARA EL TRABAJO'), 
      ('AR002', 'MANUALIDADES'), 
      ('AR003', 'ARTISTICA'), 
      ('AR004', 'IDIOMAS');
COMMIT;

# | Vaciado de tabla 'arqueocaja'
# +-------------------------------------
DROP TABLE IF EXISTS `arqueocaja`;


# | Estructura de la tabla 'arqueocaja'
# +-------------------------------------
CREATE TABLE `arqueocaja` (
  `codarqueo` int(11) NOT NULL AUTO_INCREMENT,
  `codcaja` int(11) NOT NULL,
  `montoinicial` decimal(12,2) NOT NULL,
  `ingresos` decimal(12,2) NOT NULL,
  `ingresos2` decimal(12,2) NOT NULL,
  `egresos` decimal(12,2) NOT NULL,
  `efectivocaja` decimal(12,2) NOT NULL,
  `dineroefectivo` decimal(12,2) NOT NULL,
  `diferencia` decimal(12,2) NOT NULL,
  `comentarios` text COLLATE utf8_spanish_ci NOT NULL,
  `fechaapertura` datetime NOT NULL,
  `fechacierre` datetime NOT NULL,
  `statusarqueo` int(2) NOT NULL,
  PRIMARY KEY (`codarqueo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
                
# | Carga de datos de la tabla 'arqueocaja'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `arqueocaja` (`codarqueo`, `codcaja`, `montoinicial`, `ingresos`, `ingresos2`, `egresos`, `efectivocaja`, `dineroefectivo`, `diferencia`, `comentarios`, `fechaapertura`, `fechacierre`, `statusarqueo`) VALUES 
      ('1', '1', '100.00', '312200.00', '0.00', '0.00', '0.00', '0.00', '0.00', 'NINGUNO', '2023-08-22 08:28:05', '0000-00-00 00:00:00', '1');
COMMIT;

# | Vaciado de tabla 'asignaciones'
# +-------------------------------------
DROP TABLE IF EXISTS `asignaciones`;


# | Estructura de la tabla 'asignaciones'
# +-------------------------------------
CREATE TABLE `asignaciones` (
  `codasignacion` int(11) NOT NULL AUTO_INCREMENT,
  `coddoc` int(11) NOT NULL,
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codmateria` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `fechaasignacion` date NOT NULL,
  PRIMARY KEY (`codasignacion`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'asignaciones'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `asignaciones` (`codasignacion`, `coddoc`, `codturno`, `codnivel`, `codgrado`, `codseccion`, `codmateria`, `codperiodo`, `fechaasignacion`) VALUES 
      ('1', '1', 'T001', 'N001', 'G001', 'S001', 'M0001', '1', '2023-08-23'), 
      ('2', '1', 'T001', 'N001', 'G001', 'S001', 'M0003', '1', '2023-08-23'), 
      ('3', '1', 'T001', 'N001', 'G001', 'S001', 'M0004', '1', '2023-08-23'), 
      ('4', '3', 'T001', 'N001', 'G001', 'S001', 'M0005', '1', '2023-08-23'), 
      ('5', '3', 'T001', 'N001', 'G001', 'S001', 'M0006', '1', '2023-08-23'), 
      ('6', '2', 'T001', 'N001', 'G001', 'S001', 'M0002', '1', '2023-08-23');
COMMIT;

# | Vaciado de tabla 'cajas'
# +-------------------------------------
DROP TABLE IF EXISTS `cajas`;


# | Estructura de la tabla 'cajas'
# +-------------------------------------
CREATE TABLE `cajas` (
  `codcaja` int(11) NOT NULL AUTO_INCREMENT,
  `nrocaja` varchar(15) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nombrecaja` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codigo` int(11) NOT NULL,
  PRIMARY KEY (`codcaja`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'cajas'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `cajas` (`codcaja`, `nrocaja`, `nombrecaja`, `codigo`) VALUES 
      ('1', '001', 'CAJA PRINCIPAL', '1'), 
      ('2', '002', 'CAJA #2', '2');
COMMIT;

# | Vaciado de tabla 'configuracion'
# +-------------------------------------
DROP TABLE IF EXISTS `configuracion`;


# | Estructura de la tabla 'configuracion'
# +-------------------------------------
CREATE TABLE `configuracion` (
  `id` int(11) NOT NULL,
  `ceddirector` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `director` varchar(80) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `tlfdirec` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `correodirec` varchar(120) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `codinstituto` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `nominstituto` varchar(120) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `direcinstituto` text CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `tlfinstituto` varchar(45) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `correoinstituto` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `inicioinscripcion` date DEFAULT NULL,
  `fininscripcion` date DEFAULT NULL,
  `trimestreactivo` int(2) NOT NULL,
  `inicionotas` date NOT NULL,
  `finnotas` date NOT NULL,
  `diascrealapso` int(5) NOT NULL,
  `cobrar_cuotas` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'configuracion'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `configuracion` (`id`, `ceddirector`, `director`, `tlfdirec`, `correodirec`, `codinstituto`, `nominstituto`, `direcinstituto`, `tlfinstituto`, `correoinstituto`, `inicioinscripcion`, `fininscripcion`, `trimestreactivo`, `inicionotas`, `finnotas`, `diascrealapso`, `cobrar_cuotas`) VALUES 
      ('1', '66666666', 'NOMBRE DEL DIRECTOR', '8523035', 'CORREO@GMAIL.COM', '20333942071', 'HARD SOLUTIONS', 'AV. FACUNDO QUIROGA', '3825668909', 'INFO@HARDSOLUTIONS.NET', '2023-08-01', '2023-09-20', '1', '2023-08-01', '2023-09-20', '10', '1');
COMMIT;

# | Vaciado de tabla 'contador_cuotas'
# +-------------------------------------
DROP TABLE IF EXISTS `contador_cuotas`;


# | Estructura de la tabla 'contador_cuotas'
# +-------------------------------------
CREATE TABLE `contador_cuotas` (
  `id_contador` int(11) NOT NULL AUTO_INCREMENT,
  `contador_numero` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`id_contador`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'contador_cuotas'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `contador_cuotas` (`id_contador`, `contador_numero`) VALUES 
      ('1', '04');
COMMIT;

# | Vaciado de tabla 'definitivas'
# +-------------------------------------
DROP TABLE IF EXISTS `definitivas`;


# | Estructura de la tabla 'definitivas'
# +-------------------------------------
CREATE TABLE `definitivas` (
  `coddefinitiva` int(11) NOT NULL AUTO_INCREMENT,
  `codest` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `nota_definitiva` varchar(5) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `aprobo` int(2) NOT NULL,
  `puesto` int(5) NOT NULL,
  PRIMARY KEY (`coddefinitiva`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'definitivas'
# +-------------------------------------

# | Vaciado de tabla 'detallespagos'
# +-------------------------------------
DROP TABLE IF EXISTS `detallespagos`;


# | Estructura de la tabla 'detallespagos'
# +-------------------------------------
CREATE TABLE `detallespagos` (
  `coddetalle` int(11) NOT NULL AUTO_INCREMENT,
  `numcomprobante` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codest` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `becado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `mespago` varchar(2) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `montopago` decimal(12,2) NOT NULL,
  `fechapago` date NOT NULL,
  `statuspago` int(2) NOT NULL,
  `codigo` int(11) NOT NULL,
  PRIMARY KEY (`coddetalle`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'detallespagos'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `detallespagos` (`coddetalle`, `numcomprobante`, `codest`, `codturno`, `codseccion`, `codperiodo`, `becado`, `mespago`, `montopago`, `fechapago`, `statuspago`, `codigo`) VALUES 
      ('1', '01', 'A1', 'T001', 'S001', '1', 'NO', '01', '17500.00', '2023-08-23', '1', '1'), 
      ('2', '01', 'A1', 'T001', 'S001', '1', 'NO', '02', '17500.00', '2023-08-23', '1', '1'), 
      ('3', '01', 'A1', 'T001', 'S001', '1', 'NO', '03', '17500.00', '2023-08-23', '1', '1'), 
      ('4', '0', 'A1', 'T001', 'S001', '1', 'NO', '04', '17500.00', '0000-00-00', '2', '0'), 
      ('5', '0', 'A1', 'T001', 'S001', '1', 'NO', '05', '17500.00', '0000-00-00', '2', '0'), 
      ('6', '0', 'A1', 'T001', 'S001', '1', 'NO', '06', '17500.00', '0000-00-00', '2', '0'), 
      ('7', '0', 'A1', 'T001', 'S001', '1', 'NO', '07', '17500.00', '0000-00-00', '2', '0'), 
      ('8', '0', 'A1', 'T001', 'S001', '1', 'NO', '08', '17500.00', '0000-00-00', '2', '0'), 
      ('9', '0', 'A1', 'T001', 'S001', '1', 'NO', '09', '17500.00', '0000-00-00', '0', '0'), 
      ('10', '0', 'A1', 'T001', 'S001', '1', 'NO', '10', '17500.00', '0000-00-00', '0', '0'), 
      ('11', '0', 'A1', 'T001', 'S001', '1', 'NO', '11', '17500.00', '0000-00-00', '0', '0'), 
      ('12', '0', 'A1', 'T001', 'S001', '1', 'NO', '12', '17500.00', '0000-00-00', '0', '0'), 
      ('13', '02', 'A2', 'T001', 'S001', '1', 'MEDIA', '01', '8750.00', '2023-08-23', '1', '1'), 
      ('14', '02', 'A2', 'T001', 'S001', '1', 'MEDIA', '02', '8750.00', '2023-08-23', '1', '1'), 
      ('15', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '03', '8750.00', '0000-00-00', '2', '0'), 
      ('16', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '04', '8750.00', '0000-00-00', '2', '0'), 
      ('17', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '05', '8750.00', '0000-00-00', '2', '0'), 
      ('18', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '06', '8750.00', '0000-00-00', '2', '0'), 
      ('19', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '07', '8750.00', '0000-00-00', '2', '0'), 
      ('20', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '08', '8750.00', '0000-00-00', '2', '0'), 
      ('21', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '09', '8750.00', '0000-00-00', '0', '0'), 
      ('22', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '10', '8750.00', '0000-00-00', '0', '0'), 
      ('23', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '11', '8750.00', '0000-00-00', '0', '0'), 
      ('24', '0', 'A2', 'T001', 'S001', '1', 'MEDIA', '12', '8750.00', '0000-00-00', '0', '0'), 
      ('25', '03', 'A3', 'T001', 'S001', '1', 'COMPLETA', '01', '17500.00', '2023-08-23', '1', '1'), 
      ('26', '03', 'A3', 'T001', 'S001', '1', 'COMPLETA', '12', '17500.00', '2023-08-23', '1', '1'), 
      ('27', '04', 'A4', 'T001', 'S001', '1', 'NO', '01', '17500.00', '2023-08-23', '1', '1'), 
      ('28', '04', 'A4', 'T001', 'S001', '1', 'NO', '02', '17500.00', '2023-08-23', '1', '1'), 
      ('29', '04', 'A4', 'T001', 'S001', '1', 'NO', '03', '17500.00', '2023-08-23', '1', '1'), 
      ('30', '04', 'A4', 'T001', 'S001', '1', 'NO', '04', '17500.00', '2023-08-23', '1', '1'), 
      ('31', '0', 'A4', 'T001', 'S001', '1', 'NO', '05', '17500.00', '0000-00-00', '2', '0'), 
      ('32', '0', 'A4', 'T001', 'S001', '1', 'NO', '06', '17500.00', '0000-00-00', '2', '0'), 
      ('33', '0', 'A4', 'T001', 'S001', '1', 'NO', '07', '17500.00', '0000-00-00', '2', '0'), 
      ('34', '0', 'A4', 'T001', 'S001', '1', 'NO', '08', '17500.00', '0000-00-00', '2', '0'), 
      ('35', '0', 'A4', 'T001', 'S001', '1', 'NO', '09', '17500.00', '0000-00-00', '0', '0'), 
      ('36', '0', 'A4', 'T001', 'S001', '1', 'NO', '10', '17500.00', '0000-00-00', '0', '0'), 
      ('37', '0', 'A4', 'T001', 'S001', '1', 'NO', '11', '17500.00', '0000-00-00', '0', '0'), 
      ('38', '0', 'A4', 'T001', 'S001', '1', 'NO', '12', '17500.00', '0000-00-00', '0', '0');
COMMIT;

# | Vaciado de tabla 'docentes'
# +-------------------------------------
DROP TABLE IF EXISTS `docentes`;


# | Estructura de la tabla 'docentes'
# +-------------------------------------
CREATE TABLE `docentes` (
  `coddoc` int(11) NOT NULL AUTO_INCREMENT,
  `ceddoc` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `nomdoc` varchar(90) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `tlfdoc` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `direcdoc` text CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `especdoc` varchar(70) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `fecnacdoc` date DEFAULT NULL,
  `edocivildoc` varchar(25) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `lugarnacdoc` varchar(90) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `correodoc` varchar(140) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `expedido` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `horasdoc` int(5) NOT NULL,
  `codcargodoc` varchar(15) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `clavedoc` varchar(80) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `ingresodoc` date DEFAULT NULL,
  PRIMARY KEY (`coddoc`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'docentes'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `docentes` (`coddoc`, `ceddoc`, `nomdoc`, `tlfdoc`, `direcdoc`, `especdoc`, `fecnacdoc`, `edocivildoc`, `lugarnacdoc`, `correodoc`, `expedido`, `horasdoc`, `codcargodoc`, `clavedoc`, `ingresodoc`) VALUES 
      ('1', '18633174', 'RUBEN DARIO CHIRINOS RODRIGUEZ', '04247424274', 'SANTA CRUZ DE MORA', 'ING EN SISTEMAS', '1985-10-10', 'SOLTERO(A)', 'CABIMAS ESTADO ZULIA', 'ELSAIYA@GMAIL.COM', 'SANTA CRUZ', '45', 'E455609-98', '$2y$10$BwXIgsGVFGV1MDvRAxUql.hOxkOJ3jGD9eVdk7iY2fr6KFM.YuwSy', '2023-08-22'), 
      ('2', '19855478', 'JUNIOR JOSE MORA', '02748856985', 'SANTA CRUZ DE MORA', 'DOCENTE', '1988-08-05', 'SOLTERO(A)', 'SANTA CRUZ DE MORA', 'JUNIOR@GMAIL.COM', 'TOVAR', '45', 'E-8890990012', '$2y$10$QsG7HOsc8LNjhCjpCtD/Ru6cq7FdxnABy7EVJRC0j5AO42lt6.yQq', '2023-08-22'), 
      ('3', '215445874', 'CAROLINA MORA MORA', '04145587485', 'MERIDA', 'DOCENTE', '1975-10-09', 'CASADO(A)', 'MERIDA', 'CAROLM@GMAIL.COM', 'MERIDA', '45', 'E-776666T56', '$2y$10$CCsJ3A0Qzd5tDzlPdBnDyuV4PvVctp41yIbO4JP9iUdTdtL0iigfu', '2023-08-22');
COMMIT;

# | Vaciado de tabla 'estudiantes'
# +-------------------------------------
DROP TABLE IF EXISTS `estudiantes`;


# | Estructura de la tabla 'estudiantes'
# +-------------------------------------
CREATE TABLE `estudiantes` (
  `idest` int(11) NOT NULL AUTO_INCREMENT,
  `codpadre` int(11) NOT NULL,
  `codest` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `cedest` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `pnomest` varchar(40) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `snomest` varchar(40) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `papeest` varchar(40) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `sapeest` varchar(40) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `sexoest` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `direcest` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `fnacest` date NOT NULL,
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `becado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `observacionest` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `retiroest` date NOT NULL,
  `claveest` varchar(80) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `statusest` int(2) NOT NULL,
  `fechainscripcion` date NOT NULL,
  PRIMARY KEY (`idest`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'estudiantes'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `estudiantes` (`idest`, `codpadre`, `codest`, `cedest`, `pnomest`, `snomest`, `papeest`, `sapeest`, `sexoest`, `direcest`, `fnacest`, `codturno`, `codnivel`, `codgrado`, `codseccion`, `codperiodo`, `becado`, `observacionest`, `retiroest`, `claveest`, `statusest`, `fechainscripcion`) VALUES 
      ('1', '1', 'A1', '18633174', 'RUBEN', 'DARIO', 'CHIRINOS', 'PAREDES', 'MASCULINO', 'SANTA CRUZ DE MORA', '2016-08-03', 'T001', 'N001', 'G001', 'S001', '1', 'NO', '0', '0000-00-00', '$2y$10$zO6ERRuor3Z3oGCjG6XiROzZXtzYdxIJwGMyws3YKHdfA8ydZMRD.', '1', '2023-08-23'), 
      ('2', '2', 'A2', '18633175', 'FREDDY', 'JOSE', 'MORALES', '', 'MASCULINO', 'SANTA CRUZ DE MORA', '2013-08-01', 'T001', 'N001', 'G001', 'S001', '1', 'MEDIA', '0', '0000-00-00', '$2y$10$EtzaoOeegMzomELeViyEGuX9RsUcw9CwgBQIzWmwt/1OQVguXI7Cq', '1', '2023-08-23'), 
      ('3', '2', 'A3', '18633176', 'JESUS', 'DANIEL', 'CARRILLO', 'MORA', 'MASCULINO', 'SANTA CRUZ DE MORA', '2005-08-03', 'T001', 'N001', 'G001', 'S001', '1', 'COMPLETA', '0', '0000-00-00', '$2y$10$02w/nd1Pv1IT0nFzweNHW.WHKZabfJfu74WwEcVj5DN6fHrBb9sHa', '1', '2023-08-23'), 
      ('4', '3', 'A4', '18633177', 'JEISON', 'JOSE', 'PAREDES', '', 'MASCULINO', 'SANTA CRUZ DE MORA', '2011-08-02', 'T001', 'N001', 'G001', 'S001', '1', 'NO', '0', '0000-00-00', '$2y$10$Zfjw1AJK6jvxWWbTj2cJvuMNylsVCa75uhjTQNFBiNfog8ZeTnqm2', '1', '2023-08-23');
COMMIT;

# | Vaciado de tabla 'grados'
# +-------------------------------------
DROP TABLE IF EXISTS `grados`;


# | Estructura de la tabla 'grados'
# +-------------------------------------
CREATE TABLE `grados` (
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `grado` varchar(25) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codgrado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'grados'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `grados` (`codgrado`, `codnivel`, `grado`) VALUES 
      ('G001', 'N001', 'SALA 3 AÑOS'), 
      ('G002', 'N002', 'SALA 4 AÑOS'), 
      ('G003', 'N002', 'SALA 5 AÑOS'), 
      ('G004', 'N003', '1º GRADO'), 
      ('G005', 'N003', '2º GRADO'), 
      ('G006', 'N003', '3º GRADO'), 
      ('G007', 'N003', '4º GRADO'), 
      ('G008', 'N003', '5º GRADO'), 
      ('G009', 'N003', '6º GRADO'), 
      ('G010', 'N003', '7º GRADO');
COMMIT;

# | Vaciado de tabla 'log'
# +-------------------------------------
DROP TABLE IF EXISTS `log`;


# | Estructura de la tabla 'log'
# +-------------------------------------
CREATE TABLE `log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `tiempo` datetime DEFAULT NULL,
  `detalles` text CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `paginas` text CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `usuario` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'log'
# +-------------------------------------

# | Vaciado de tabla 'materias'
# +-------------------------------------
DROP TABLE IF EXISTS `materias`;


# | Estructura de la tabla 'materias'
# +-------------------------------------
CREATE TABLE `materias` (
  `codmateria` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codarea` varchar(5) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nommateria` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codmateria`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'materias'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `materias` (`codmateria`, `codarea`, `nommateria`, `codnivel`, `codgrado`) VALUES 
      ('M0001', 'AR001', 'DIBUJO TECNICO', 'N001', 'G001'), 
      ('M0002', 'AR001', 'HUERTO', 'N001', 'G001'), 
      ('M0003', 'AR001', 'DISEÑO WEB', 'N001', 'G001'), 
      ('M0004', 'AR003', 'ARTISTICA', 'N001', 'G001'), 
      ('M0005', 'AR003', 'CASTELLANO', 'N001', 'G001'), 
      ('M0006', 'AR001', 'VALORES', 'N001', 'G001');
COMMIT;

# | Vaciado de tabla 'mediospagos'
# +-------------------------------------
DROP TABLE IF EXISTS `mediospagos`;


# | Estructura de la tabla 'mediospagos'
# +-------------------------------------
CREATE TABLE `mediospagos` (
  `codmediopago` int(11) NOT NULL AUTO_INCREMENT,
  `mediopago` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codmediopago`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
                
# | Carga de datos de la tabla 'mediospagos'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `mediospagos` (`codmediopago`, `mediopago`) VALUES 
      ('1', 'EFECTIVO'), 
      ('2', 'TARJETA DEBITO'), 
      ('3', 'TARJETA CRÉDITO'), 
      ('4', 'TRANFERENCIA');
COMMIT;

# | Vaciado de tabla 'mediospagoxpagos'
# +-------------------------------------
DROP TABLE IF EXISTS `mediospagoxpagos`;


# | Estructura de la tabla 'mediospagoxpagos'
# +-------------------------------------
CREATE TABLE `mediospagoxpagos` (
  `idpago` int(11) NOT NULL AUTO_INCREMENT,
  `codarqueo` int(11) NOT NULL,
  `codcaja` int(11) NOT NULL,
  `numcomprobante` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codmediopago` int(11) NOT NULL,
  `montopagado` decimal(12,2) NOT NULL,
  `montodevuelto` decimal(12,2) NOT NULL,
  PRIMARY KEY (`idpago`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
                
# | Carga de datos de la tabla 'mediospagoxpagos'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `mediospagoxpagos` (`idpago`, `codarqueo`, `codcaja`, `numcomprobante`, `codmediopago`, `montopagado`, `montodevuelto`) VALUES 
      ('1', '1', '1', '01', '1', '52500.00', '0.00'), 
      ('2', '1', '1', '02', '2', '17500.00', '0.00'), 
      ('3', '1', '1', '03', '3', '35000.00', '0.00'), 
      ('4', '1', '1', '04', '1', '67200.00', '0.00');
COMMIT;

# | Vaciado de tabla 'movimientoscajas'
# +-------------------------------------
DROP TABLE IF EXISTS `movimientoscajas`;


# | Estructura de la tabla 'movimientoscajas'
# +-------------------------------------
CREATE TABLE `movimientoscajas` (
  `codmovimiento` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `codarqueo` int(11) NOT NULL,
  `codcaja` int(11) NOT NULL,
  `tipomovimiento` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nrorecibo` varchar(25) COLLATE utf8_spanish_ci NOT NULL,
  `montomovimiento` float(12,2) NOT NULL,
  `descripcionmovimiento` text COLLATE utf8_spanish_ci NOT NULL,
  `fechamovimiento` datetime NOT NULL,
  PRIMARY KEY (`codmovimiento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
                
# | Carga de datos de la tabla 'movimientoscajas'
# +-------------------------------------

# | Vaciado de tabla 'niveles'
# +-------------------------------------
DROP TABLE IF EXISTS `niveles`;


# | Estructura de la tabla 'niveles'
# +-------------------------------------
CREATE TABLE `niveles` (
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nivel` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `pagonivel` decimal(12,2) NOT NULL,
  PRIMARY KEY (`codnivel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'niveles'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `niveles` (`codnivel`, `nivel`, `pagonivel`) VALUES 
      ('N001', 'NIVEL INICIAL (SALA DE 3)', '17500.00'), 
      ('N002', 'NIVEL INICIAL (SALA 4 Y 5 AÑOS)', '19000.00'), 
      ('N003', 'NIVEL PRIMARIO', '20000.00');
COMMIT;

# | Vaciado de tabla 'notas'
# +-------------------------------------
DROP TABLE IF EXISTS `notas`;


# | Estructura de la tabla 'notas'
# +-------------------------------------
CREATE TABLE `notas` (
  `codnota` int(11) NOT NULL AUTO_INCREMENT,
  `codest` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `coddoc` int(11) NOT NULL,
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `codmateria` varchar(5) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nota1` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `faltas1` int(2) NOT NULL,
  `nota2` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `faltas2` int(2) NOT NULL,
  `nota3` text CHARACTER SET utf32 COLLATE utf32_spanish_ci NOT NULL,
  `faltas3` int(2) NOT NULL,
  `nota4` text CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `faltas4` int(2) NOT NULL,
  `definitiva` varchar(5) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `literal` varchar(5) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `total_faltas` int(2) NOT NULL,
  PRIMARY KEY (`codnota`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'notas'
# +-------------------------------------

# | Vaciado de tabla 'padres'
# +-------------------------------------
DROP TABLE IF EXISTS `padres`;


# | Estructura de la tabla 'padres'
# +-------------------------------------
CREATE TABLE `padres` (
  `codpadre` int(11) NOT NULL AUTO_INCREMENT,
  `cedpadre` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nompadre` varchar(45) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `apepadre` varchar(45) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `tlfpadre` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `statuspad` int(1) NOT NULL,
  PRIMARY KEY (`codpadre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'padres'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `padres` (`codpadre`, `cedpadre`, `nompadre`, `apepadre`, `tlfpadre`, `statuspad`) VALUES 
      ('1', '16317737', 'MARBELLA', 'PAREDES MARQUEZ', '04247424274', '1'), 
      ('2', '133243456', 'YENNIFER', 'ZAMBRANO', '04247485478', '1'), 
      ('3', '213445434', 'CAROLINA', 'ZANCHEZ', '04247885458', '1');
COMMIT;

# | Vaciado de tabla 'pagos'
# +-------------------------------------
DROP TABLE IF EXISTS `pagos`;


# | Estructura de la tabla 'pagos'
# +-------------------------------------
CREATE TABLE `pagos` (
  `codpago` int(11) NOT NULL AUTO_INCREMENT,
  `codarqueo` int(11) NOT NULL,
  `codcaja` int(11) NOT NULL,
  `numcomprobante` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codest` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codperiodo` int(11) NOT NULL,
  `becado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `descuento` decimal(12,2) NOT NULL,
  `totaldescuento` decimal(12,2) NOT NULL,
  `montoinscripcion` decimal(12,2) NOT NULL,
  `cuotaunica` decimal(12,2) NOT NULL,
  `montomesextra` decimal(12,2) NOT NULL,
  `totalvencidas` int(2) NOT NULL,
  `totalpendiente` int(2) NOT NULL,
  `totalpagada` int(2) NOT NULL,
  `totalintereses` decimal(12,2) NOT NULL,
  `totalpago` decimal(12,2) NOT NULL,
  `codmediopago` int(11) NOT NULL,
  `codigo` int(11) NOT NULL,
  `fechapago` date NOT NULL,
  PRIMARY KEY (`codpago`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
                
# | Carga de datos de la tabla 'pagos'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `pagos` (`codpago`, `codarqueo`, `codcaja`, `numcomprobante`, `codest`, `codturno`, `codnivel`, `codgrado`, `codseccion`, `codperiodo`, `becado`, `subtotal`, `descuento`, `totaldescuento`, `montoinscripcion`, `cuotaunica`, `montomesextra`, `totalvencidas`, `totalpendiente`, `totalpagada`, `totalintereses`, `totalpago`, `codmediopago`, `codigo`, `fechapago`) VALUES 
      ('1', '1', '1', '01', 'A1', 'T001', 'N001', 'G001', 'S001', '1', 'NO', '52500.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0', '0', '0', '0.00', '52500.00', '1', '1', '2023-08-23'), 
      ('2', '1', '1', '02', 'A2', 'T001', 'N001', 'G001', 'S001', '1', 'MEDIA', '17500.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0', '0', '0', '0.00', '17500.00', '2', '1', '2023-08-23'), 
      ('3', '1', '1', '03', 'A3', 'T001', 'N001', 'G001', 'S001', '1', 'COMPLETA', '35000.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0', '0', '0', '0.00', '35000.00', '3', '1', '2023-08-23'), 
      ('4', '1', '1', '04', 'A4', 'T001', 'N001', 'G001', 'S001', '1', 'NO', '70000.00', '4.00', '2800.00', '0.00', '0.00', '0.00', '0', '0', '0', '0.00', '67200.00', '1', '1', '2023-08-23');
COMMIT;

# | Vaciado de tabla 'periodoescolar'
# +-------------------------------------
DROP TABLE IF EXISTS `periodoescolar`;


# | Estructura de la tabla 'periodoescolar'
# +-------------------------------------
CREATE TABLE `periodoescolar` (
  `codperiodo` int(11) NOT NULL AUTO_INCREMENT,
  `periodo` varchar(25) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `descripcion` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `fechacreado` date DEFAULT NULL,
  `mesesactivos` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `montoinscripcion` decimal(12,2) NOT NULL,
  `interesmora` decimal(12,2) NOT NULL,
  `cuotaunica` decimal(12,2) NOT NULL,
  `diasvence` int(2) NOT NULL,
  `statusperiodo` int(2) NOT NULL,
  PRIMARY KEY (`codperiodo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'periodoescolar'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `periodoescolar` (`codperiodo`, `periodo`, `descripcion`, `fechacreado`, `mesesactivos`, `montoinscripcion`, `interesmora`, `cuotaunica`, `diasvence`, `statusperiodo`) VALUES 
      ('1', '2023', 'CICLO 2023', '2023-08-15', '01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12', '0.00', '3000.00', '0.00', '10', '1');
COMMIT;

# | Vaciado de tabla 'secciones'
# +-------------------------------------
DROP TABLE IF EXISTS `secciones`;


# | Estructura de la tabla 'secciones'
# +-------------------------------------
CREATE TABLE `secciones` (
  `codseccion` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codnivel` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `codgrado` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `seccion` varchar(2) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codseccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'secciones'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `secciones` (`codseccion`, `codnivel`, `codgrado`, `seccion`) VALUES 
      ('S001', 'N001', 'G001', 'A'), 
      ('S002', 'N001', 'G001', 'B'), 
      ('S003', 'N001', 'G001', 'C');
COMMIT;

# | Vaciado de tabla 'turnos'
# +-------------------------------------
DROP TABLE IF EXISTS `turnos`;


# | Estructura de la tabla 'turnos'
# +-------------------------------------
CREATE TABLE `turnos` (
  `codturno` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `turno` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codturno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'turnos'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `turnos` (`codturno`, `turno`) VALUES 
      ('T001', 'MAÑANA'), 
      ('T002', 'TARDE');
COMMIT;

# | Vaciado de tabla 'usuarios'
# +-------------------------------------
DROP TABLE IF EXISTS `usuarios`;


# | Estructura de la tabla 'usuarios'
# +-------------------------------------
CREATE TABLE `usuarios` (
  `codigo` int(11) NOT NULL AUTO_INCREMENT,
  `cedula` varchar(25) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nombres` varchar(70) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `telefono` varchar(15) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `sexo` varchar(10) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `cargo` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `usuario` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `password` longtext CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `nivel` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `status` varchar(15) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
                
# | Carga de datos de la tabla 'usuarios'
# +-------------------------------------

COMMIT;
INSERT IGNORE INTO `usuarios` (`codigo`, `cedula`, `nombres`, `telefono`, `sexo`, `cargo`, `email`, `usuario`, `password`, `nivel`, `status`) VALUES 
      ('1', '18633174', 'RUBEN DARIO CHIRINOS RODRIGUEZ', '04247424274', 'MASCULINO', 'WEBMASTER', 'ELSAIYA@GMAIL.COM', 'RUBENCHIRINOS', '$2y$10$k/6ThdNG4Wp1ldOP6/oruOXec5iFqrbP5Ib.HvF6BH362BSP6gfqu', 'ADMINISTRADOR(A)', 'ACTIVO'), 
      ('2', '16859685', 'MARBELLA PAREDES MARQUEZ', '04124587458', 'FEMENINO', 'ING EN SISTEMAS', 'MAR@GMAIL.COM', 'SECRETARIA', '$2y$10$Bfy83cW.SpUSQ0pVo3L8AeCHuZFnJmbAMRhW7tJZhr5dIgEbFCLf2', 'SECRETARIA', 'ACTIVO');
COMMIT;


