<?php
define('FPDF_FONTPATH','fpdf/font/');
define('EURO', chr(128));
require 'pdf_js.php';
 
class PDF extends PDF_JavaScript
{
var $widths;
var $aligns;
var $flowingBlockAttr;
########################## FUNCION PARA MOSTRAR EL FOOTER ###################################
   

########################### FUNCION PARA MOSTRAR EL FOOTER ###########################
function Footer()
{
    //Posicin: a 2 cm del final
	$this->Ln();
	$this->SetY(-15);
	$this->SetFont('courier','B',10);
    //Nmero de pgina
	//$this->Cell(190,5,'SIGA - SISTEMA INTEGRADO PARA LA GESTIN ACADMICA','T',0,'L');
	$this->AliasNbPages();
	//$this->Cell(0,5,'Pagina '.$this->PageNo(),'T',1,'R');
    //Page number
    /*$pagenumber = '{nb}';
    if($this->PageNo() == 2){
        $this->Cell(173,10, ' FOOTER TEST  -  '.$pagenumber, 0, 0);
    }*/

    if($this->page>0)
    {
        // Page footer
        //$this->InFooter = true;
        //$this->Footer();
        //$this->InFooter = false;
        // Close page
        $this->_endpage();
    }
}
########################## FUNCION PARA MOSTRAR EL FOOTER ############################
    
######################## FUNCION PARA CARGAR AUTOPRINTF ########################
function AutoPrint($printer='')
{
    // Open the print dialog
    if($printer)
    {
        $printer = str_replace('\\', '\\\\', $printer);
        $script = "var pp = getPrintParams();";
        $script .= "pp.interactive = pp.constants.interactionLevel.full;";
        $script .= "pp.printerName = '$printer'";
        $script .= "print(pp);";
    }
    else
        $script = 'print(true);';
    $this->IncludeJS($script);
}
######################## FUNCION PARA CARGAR AUTOPRINT ########################



################################### REPORTES DE MANTENIMIENTO ##################################

########################## FUNCION LISTAR USUARIOS ##############################
function TablaListarUsuarios()
{
    $tra = new Login();
    $reg = $tra->ListarUsuarios();

	################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO GENERAL DE USUARIOS',0,0,'C');
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(30,8,'TELEFONO',1,0,'C', True);
    $this->Cell(25,8,'SEXO',1,0,'C', True);
    $this->Cell(40,8,'CARGO',1,0,'C', True);
    $this->Cell(55,8,'EMAIL',1,0,'C', True);
    $this->Cell(40,8,'USUARIO',1,0,'C', True);
    $this->Cell(40,8,'NIVEL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,60,30,25,40,55,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["cedula"]),utf8_decode($reg[$i]["nombres"]),utf8_decode($reg[$i]["telefono"] == "" ? "******" : $reg[$i]['telefono']),utf8_decode($reg[$i]["sexo"]),utf8_decode($reg[$i]["cargo"]),utf8_decode($reg[$i]["email"]),utf8_decode($reg[$i]["usuario"]),utf8_decode($reg[$i]["nivel"])));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(120,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(120,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR USUARIOS ##############################

########################## FUNCION LISTAR USUARIOS ##############################
function TablaListarLogs()
{
	$tra = new Login();
    $reg = $tra->ListarLogs();

    ################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO GENERAL DE LOGS DE ACCESO DE USUARIOS',0,0,'C');
	
	$this->Ln();
	$this->SetFont('Courier','B',12);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(35,8,'IP EQUIPO',1,0,'C', True);
	$this->Cell(45,8,'TIEMPO ENTRADA',1,0,'C', True);
	$this->Cell(145,8,'NAVEGADOR DE ACCESO',1,0,'C', True);
	$this->Cell(60,8,'PGINAS DE ACCESO',1,0,'C', True);
	$this->Cell(35,8,'USUARIO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
	
    /* AQUI DECLARO LAS COLUMNAS */
	$this->SetWidths(array(10,35,45,145,60,35));

	/* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
	$a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
	$this->SetFont('Courier','',12);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Row(array($a++,utf8_decode($reg[$i]["ip"]),utf8_decode($reg[$i]["tiempo"]),utf8_decode($reg[$i]["detalles"]),utf8_decode($reg[$i]["paginas"]),utf8_decode($reg[$i]["usuario"])));
       }
   }

    $this->Ln(12); 
    $this->SetFont('Courier','B',12);
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(120,6,'RECIBIDO POR:______________________________________________',0,0,'');
    $this->Ln();
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(120,6,'',0,0,'');
    $this->Ln(11);
}
########################## FUNCION LISTAR USUARIOS ##############################

############################# FUNCION REPORTES DE MATERIAS ##############################
function TablaListarMaterias()
{
	$tra = new Login();
    $reg = $tra->ListarMaterias();
	
	################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
	################################# MEMBRETE A4 #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(195,8,'LISTADO GENERAL DE MATERIAS',0,0,'C');
	
	$this->Ln();
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(20,8,'CDIGO',1,0,'C', True);
	$this->Cell(50,8,'NOMBRE DE REA',1,0,'C', True);
	$this->Cell(50,8,'NOMBRE DE MATERIA',1,0,'C', True);
	$this->Cell(35,8,'NIVEL',1,0,'C', True);
	$this->Cell(30,8,'GRADO',1,1,'C', True);
	
	/* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,50,50,35,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    if($reg==""){
    echo "";      
    } else {

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codmateria"]),utf8_decode($reg[$i]["nomarea"]),utf8_decode($reg[$i]["nommateria"]),utf8_decode($reg[$i]["nivel"]),utf8_decode($reg[$i]["grado"])));
        } 
    }
   
    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
############################# FUNCION REPORTES DE MATERIAS ##############################

############################# FUNCION REPORTES DE MATERIAS ##############################
function TablaListarMateriasCursos()
{
	$tra = new Login();
    $reg = $tra->BuscarMateriasReportes();
	
	################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
	################################# MEMBRETE A4 #################################
	
	$this->SetFont('Courier','B',12);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(195,8,'LISTADO DE MATERIAS POR CURSOS',0,0,'C');

    $this->Ln();
    $this->Cell(195,5,"NIVEL: ".utf8_decode($reg[0]['nivel']),0,0,'L');
    $this->Ln();
    $this->Cell(195,5,"GRADO: ".portales(utf8_decode($reg[0]['grado'])),0,0,'L');
	
	$this->Ln(10);
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(20,8,'CDIGO',1,0,'C', True);
	$this->Cell(80,8,'NOMBRE DE REA',1,0,'C', True);
	$this->Cell(85,8,'NOMBRE DE MATERIA',1,1,'C', True);
	
	/* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,80,85));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]["codmateria"]),utf8_decode($reg[$i]["nomarea"]),utf8_decode($reg[$i]["nommateria"])));
    }
   
    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
############################# FUNCION REPORTES DE MATERIAS ##############################

################################### REPORTES DE MANTENIMIENTO ##################################
	

	
	
















################################### REPORTES DE CAJAS ###################################

############################ FUNCION LISTAR ARQUEOS DE CAJAS ################################
function TablaListarCajas()
{ 
    $tra = new Login();
    $reg = $tra->ListarCajas();

    ################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
	################################# MEMBRETE A4 #################################
	
	$this->SetFont('Courier','B',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(195,8,'LISTADO GENERAL DE CAJAS',0,0,'C');
	
	$this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE CAJA',1,0,'C', True);
    $this->Cell(55,8,'NOMBRE DE CAJA',1,0,'C', True);
    $this->Cell(90,8,'RESPONSABLE',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
    /* AQUI DECLARO LAS COLUMNAS */
	$this->SetWidths(array(10,35,55,90));

	/* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
	$a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
	$this->SetFont('Courier','',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Row(array($a++,utf8_decode($reg[$i]["nrocaja"]),utf8_decode($reg[$i]['nombrecaja']),portales(utf8_decode($reg[$i]["nombres"]))));
      }
   }


    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
############################ FUNCION LISTAR DE CAJAS ################################

########################## FUNCION TICKET CIERRE ARQUEO ##############################
function TicketCierre()
{  
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $tra = new Login();
    $reg = $tra->ArqueoCajaPorId();

    if (file_exists("fotos/logo_principal.png")) {

    $logo = "fotos/logo_principal.png";
      $this->Image($logo , 26, 4, 20, 12, "PNG");
      $this->Ln(6);
    }
  
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE CIERRE", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,4,utf8_decode($con[0]['nominstituto']), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['codinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['direcinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['correoinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,"EMISIN: NORMAL",0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"CAJA N:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nombrecaja']),0,1,'L');
    
    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"CAJERO:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(50,3,utf8_decode($reg[0]['nombres']),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"FECHA EMISIN:",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"HORA APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg[0]['fechaapertura']))),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"HORA CIERRE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(date("d-m-Y H:i:s",strtotime($reg[0]['fechacierre']))),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"MONTO APERTURA:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(40,3,utf8_decode(number_format($reg[0]["montoinicial"], 2, '.', ',')),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,3,"DESGLOSE EN VENTAS",0,1,'C');
    $this->Ln(1);

    $a=1;
    $Ventas_Efectivo = 0;
    for($i=0;$i<sizeof($reg);$i++):
    $Ventas_Efectivo += ($reg[$i]['mediopago'] == "EFECTIVO" ? $reg[$i]['montopagado'] : 0);
    if($reg[$i]['mediopago'] != ""){

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,utf8_decode($reg[$i]['mediopago']),0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[$i]['montopagado'], 2, '.', ',')),0,1,'R');

    }
    endfor;

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"INGRESOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["ingresos"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,3,"MOVIMIENTOS EN CAJA",0,1,'C');
    $this->Ln(1);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"INGRESOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["ingresos2"], 2, '.', ',')),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EGRESOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["egresos"], 2, '.', ',')),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(70,3,"REPORTE DE CAJA",0,1,'C');
    $this->Ln(1);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"TOTAL EN INGRESOS:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]['ingresos'], 2, '.', ',')),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"TOTAL EN EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format(($reg[0]["montoinicial"]+$Ventas_Efectivo+$reg[0]["ingresos2"])-$reg[0]["egresos"], 2, '.', ',')),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EFECTIVO DISPONIBLE:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["dineroefectivo"], 2, '.', ',')),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"DIF. EFECTIVO:",0,0,'L');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(6,3,' ',0,0,'R');
    $this->SetFont('Courier',"B",8);
    $this->CellFitSpace(30,3,utf8_decode(number_format($reg[0]["diferencia"], 2, '.', ',')),0,1,'R');

    if($reg[0]["comentarios"]==""){

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    } else { 

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'--------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->MultiCell(70,4,$this->SetFont('Courier',"",7).utf8_decode($reg[0]["comentarios"]),0,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    }
 
    $this->SetFont('Courier','BI',9);
    $this->SetX(2);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(70,3," ",0,1,'C');
    $this->Ln(33);     
}
########################## FUNCION TICKET CIERRE ARQUEO ##############################

############################ FUNCION LISTAR ARQUEOS DE CAJAS ################################
function TablaListarArqueos()
{ 
    $tra = new Login();
    $reg = $tra->ListarArqueoCaja();

    ################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO GENERAL DE ARQUEOS DE CAJAS',0,0,'C');
	
	$this->Ln();
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(66,8,'N DE CAJA',1,0,'C', True);
    $this->Cell(28,8,'INICIO',1,0,'C', True);
    $this->Cell(28,8,'CIERRE',1,0,'C', True);
    $this->Cell(26,8,'INICIAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL INGRESOS',1,0,'C', True);
    $this->Cell(35,8,'INGRESOS MOV.',1,0,'C', True);
    $this->Cell(35,8,'EFECT EN CAJA',1,0,'C', True);
    $this->Cell(35,8,'EFECT DISPON',1,0,'C', True);
    $this->Cell(32,8,'DIFER EFECT',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,66,28,28,26,35,35,35,35,32));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalIngresos=0;
	$TotalMovimientos=0;
	$TotalCaja=0;
	$TotalEfectivo=0;
	$TotalDiferencia=0;

	for($i=0;$i<sizeof($reg);$i++){

	$TotalIngresos+=$reg[$i]['ingresos'];
	$TotalMovimientos+=$reg[$i]['ingresos2'];
	$TotalCaja+=$reg[$i]['efectivocaja'];
	$TotalEfectivo+=$reg[$i]['dineroefectivo'];
	$TotalDiferencia+=$reg[$i]['diferencia'];

    $this->SetFont('Courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nombrecaja'].":".$reg[$i]['nombres']),
        utf8_decode( date("d-m-Y H:i:s",strtotime($reg[$i]['fechaapertura']))),
        utf8_decode($reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "*********" : date("d-m-Y H:i:s",strtotime($reg[$i]['fechacierre']))),
        utf8_decode(number_format($reg[$i]['montoinicial'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['ingresos'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['ingresos2'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['efectivocaja'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['dineroefectivo'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['diferencia'], 2, '.', ','))));
    }

    $this->Cell(158,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalIngresos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalMovimientos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalCaja, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(35,5,utf8_decode(number_format($TotalEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(32,5,utf8_decode(number_format($TotalDiferencia, 2, '.', ',')),0,0,'L');
    $this->Ln();

    }


    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
############################ FUNCION LISTAR ARQUEOS DE CAJAS ################################

############################ FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ################################
function TablaListarArqueosFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarArqueosxFechas();

    ################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO DE ARQUEOS POR CAJAS',0,0,'C');

    $this->Ln();
    $this->Cell(330,6,"N DE CAJA: ".utf8_decode($reg[0]['nrocaja'].": ".$reg[0]['nombrecaja']),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"RESPONSABLE: ".portales(utf8_decode($reg[0]['nombres'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,0,'L');
	
	$this->Ln(10);
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(52,8,'INICIO',1,0,'C', True);
    $this->Cell(52,8,'CIERRE',1,0,'C', True);
    $this->Cell(36,8,'INICIAL',1,0,'C', True);
    $this->Cell(38,8,'TOTAL INGRESOS',1,0,'C', True);
    $this->Cell(36,8,'INGRESOS MOV.',1,0,'C', True);
    $this->Cell(36,8,'EFECT EN CAJA',1,0,'C', True);
    $this->Cell(36,8,'EFECT DISPON',1,0,'C', True);
    $this->Cell(32,8,'DIFER EFECT',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,52,52,36,38,36,36,36,32));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalIngresos=0;
	$TotalMovimientos=0;
	$TotalCaja=0;
	$TotalEfectivo=0;
	$TotalDiferencia=0;

	for($i=0;$i<sizeof($reg);$i++){

	$TotalIngresos+=$reg[$i]['ingresos'];
	$TotalMovimientos+=$reg[$i]['ingresos2'];
	$TotalCaja+=$reg[$i]['efectivocaja'];
	$TotalEfectivo+=$reg[$i]['dineroefectivo'];
	$TotalDiferencia+=$reg[$i]['diferencia'];

    $this->SetFont('Courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]['fechaapertura']))),
        utf8_decode($reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "*********" : date("d-m-Y H:i:s",strtotime($reg[$i]['fechacierre']))),
        utf8_decode(number_format($reg[$i]['montoinicial'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['ingresos'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['ingresos2'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['efectivocaja'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['dineroefectivo'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['diferencia'], 2, '.', ','))));
        }
    }


    $this->Cell(150,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(38,5,utf8_decode(number_format($TotalIngresos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(36,5,utf8_decode(number_format($TotalMovimientos, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(36,5,utf8_decode(number_format($TotalCaja, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(36,5,utf8_decode(number_format($TotalEfectivo, 2, '.', ',')),0,0,'L');
    $this->CellFitSpace(32,5,utf8_decode(number_format($TotalDiferencia, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
############################ FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ################################

########################## FUNCION TICKET MOVIMIENTOS EN CAJA ##############################
function TicketMovimiento()
{  
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $tra = new Login();
    $reg = $tra->MovimientoCajasPorId();

    if (file_exists("fotos/logo_principal.png")) {

    $logo = "fotos/logo_principal.png";
      $this->Image($logo , 26, 4, 20, 12, "PNG");
      $this->Ln(6);
    }
  
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE MOVIMIENTO", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,4,utf8_decode($con[0]['nominstituto']), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['codinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['direcinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,utf8_decode($con[0]['correoinstituto']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,"N DE TICKET: ".utf8_decode($reg[0]['numero']),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,"EMISIN: NORMAL",0,1,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJA N",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nrocaja']."-".$reg[0]['nombrecaja']),0,1,'R');
    
    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"CAJERO",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MONTO",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode(number_format($reg[0]["montomovimiento"], 2, '.', ',')),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"MEDIO",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode("EFECTIVO"),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(16,3,"TIPO",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(54,3,utf8_decode($reg[0]['tipomovimiento']),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"N RECIBO/FACTURA",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,utf8_decode($reg[0]['nrorecibo']),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',8)."NOTA: ".utf8_decode($reg[0]['descripcionmovimiento']),0,'J');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"FECHA MOVIMIENTO",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s",strtotime($reg[0]['fechamovimiento'])),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"FECHA EMISIN",0,0,'L');
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(40,3,date("d-m-Y H:i:s"),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetFont('Courier','BI',9);
    $this->SetX(2);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(70,3,"MUCHAS GRACIAS",0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET MOVIMIENTOS EN CAJA ##############################

############################### FUNCION LISTAR MOVIMIENTOS DE CAJAS #################################
function TablaListarMovimientos()
{
    $movim = new Login();
    $reg = $movim->ListarMovimientoCajas();
    
    ################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
	################################# MEMBRETE A4 #################################
	
	$this->SetFont('Courier','B',12);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(195,8,'LISTADO GENERAL DE MOVIMIENTOS DE CAJAS',0,0,'C');
	
	$this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->CellFitSpace(10,8,'N',1,0,'C', True);
    $this->CellFitSpace(30,8,'N CAJA',1,0,'C', True);
    $this->CellFitSpace(25,8,'N FACT/REC',1,0,'C', True);
    $this->CellFitSpace(60,8,'DESCRIPCIN DE MOVIMIENTO',1,0,'C', True);
    $this->CellFitSpace(18,8,'TIPO',1,0,'C', True);
    $this->CellFitSpace(28,8,'MONTO',1,0,'C', True);
    $this->CellFitSpace(24,8,'FECHA MOV.',1,1,'C', True);
    
    if($reg==""){
	echo "";      
	} else {

	/* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,25,60,18,28,24));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalIngresos = "0";
	$TotalEgresos = "0";
    for($i=0;$i<sizeof($reg);$i++){
    $TotalIngresos+=$ingresos = ( $reg[$i]['tipomovimiento'] == 'INGRESO' ? $reg[$i]['montomovimiento'] : "0.00");
	$TotalEgresos+=$egresos = ( $reg[$i]['tipomovimiento'] == 'EGRESO' ? $reg[$i]['montomovimiento'] : "0.00");

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,utf8_decode($reg[$i]['nrocaja'].": ".$reg[$i]['nombrecaja']),
    	utf8_decode($reg[$i]["nrorecibo"]),
    	utf8_decode($reg[$i]['descripcionmovimiento']),
    	utf8_decode($reg[$i]["tipomovimiento"]),
    	utf8_decode(number_format($reg[$i]['montomovimiento'], 2, '.', ',')),
    	utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]["fechamovimiento"])))));
       }
    
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(95,6,'',0,1,'C');
    $this->Cell(95,6,'DETALLES DE MOVIMIENTO',1,0,'C', True);
    $this->Ln();

    if($_SESSION['acceso'] == "secretaria") {

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'RESPONSABLE DE CAJA',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,utf8_decode($reg[0]['nombres']),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'NOMBRE DE CAJA',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,utf8_decode($reg[0]['nrocaja'].": ".$reg[0]['nombrecaja']),1,0,'C');
    $this->Ln();

    }

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL INGRESOS',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalIngresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL EGRESOS',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalEgresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL GENERAL',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalIngresos-$TotalEgresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
############################### FUNCION LISTAR MOVIMIENTOS DE CAJAS #################################

############################### FUNCION LISTAR MOVIMIENTOS POR FECHAS #################################
function TablaListarMovimientosFechas()
{
    $movim = new Login();
    $reg = $movim->BuscarMovimientosxFechas();
    
    ################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
	################################# MEMBRETE A4 #################################
	
	$this->SetFont('Courier','B',12);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(195,8,'LISTADO GENERAL DE MOVIMIENTOS POR CAJAS',0,0,'C');

    $this->Ln();
    $this->Cell(190,5,"N DE CAJA: ".utf8_decode($reg[0]['nrocaja'].": ".$reg[0]['nombrecaja']),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"RESPONSABLE: ".portales(utf8_decode($reg[0]['nombres'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,0,'L');
	
	$this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->CellFitSpace(10,8,'N',1,0,'C', True);
    $this->CellFitSpace(35,8,'N FACT/REC',1,0,'C', True);
    $this->CellFitSpace(70,8,'DESCRIPCIN DE MOVIMIENTO',1,0,'C', True);
    $this->CellFitSpace(22,8,'TIPO',1,0,'C', True);
    $this->CellFitSpace(32,8,'MONTO',1,0,'C', True);
    $this->CellFitSpace(26,8,'FECHA MOV.',1,1,'C', True);
    
    if($reg==""){
	echo "";      
	} else {

	/* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,70,22,32,26));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalIngresos = "0";
	$TotalEgresos = "0";
    for($i=0;$i<sizeof($reg);$i++){
    $TotalIngresos+=$ingresos = ( $reg[$i]['tipomovimiento'] == 'INGRESO' ? $reg[$i]['montomovimiento'] : "0.00");
	$TotalEgresos+=$egresos = ( $reg[$i]['tipomovimiento'] == 'EGRESO' ? $reg[$i]['montomovimiento'] : "0.00");

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
    	utf8_decode($reg[$i]["nrorecibo"]),
    	utf8_decode($reg[$i]['descripcionmovimiento']),
    	utf8_decode($reg[$i]["tipomovimiento"]),
    	utf8_decode(number_format($reg[$i]['montomovimiento'], 2, '.', ',')),
    	utf8_decode(date("d-m-Y H:i:s",strtotime($reg[$i]["fechamovimiento"])))));
       }
    }
   
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(95,6,'',0,1,'C');
    $this->Cell(95,6,'DETALLES DE MOVIMIENTO',1,0,'C', True);
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL INGRESOS',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalIngresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL EGRESOS',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalEgresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(35,5,'TOTAL GENERAL',1,0,'C', True);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,number_format($TotalIngresos-$TotalEgresos, 2, '.', ','),1,0,'C');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
############################### FUNCION LISTAR MOVIMIENTOS POR FECHAS #################################

################################### REPORTES DE CAJAS ###################################




















################################# FUNCION DOCENTES Y ASIGNACIONES DE CURSOS #################################

################################ FUNCION LISTAR DOCENTES #################################
function TablaListarDocentes()
{
    $tra = new Login();
    $reg = $tra->ListarDocentes();
   
    ################################# MEMBRETE LETTER #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+40, $this->GetY()+2, 24),5,0,'L');
    $this->Cell(170,5,utf8_decode($con[0]['nominstituto']),5,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-34, $this->GetY()+1, 24),5,0,'L');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"N DE TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
    ################################# MEMBRETE LETTER #################################

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(255,10,'LISTADO GENERAL DE DOCENTES',0,0,'C');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE DOC.',1,0,'C', True);
    $this->Cell(70,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(45,8,'ESPECIALIDAD',1,0,'C', True);
    $this->Cell(70,8,'DIRECCIN DOMICILIARIA',1,0,'C', True);
    $this->Cell(30,8,'TELFONO',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,70,45,70,30));

    if($reg==""){
    echo "";      
    } else {
 
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["ceddoc"]),
        portales(utf8_decode($reg[$i]["nomdoc"])),
        portales(utf8_decode($reg[$i]['especdoc'])),
        utf8_decode($reg[$i]["direcdoc"]),
        utf8_decode($reg[$i]["tlfdoc"])));

        }
    }
    
    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(70,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(70,6,'',0,0,'');
    $this->Ln(4);
}
################################ FUNCION LISTAR DOCENTES #################################

################################ FUNCION LISTAR ASIGNACIONES DE MATERIAS A DOCENTES #################################
function TablaListarAsignaciones()
{
    $tra = new Login();
    $reg = $tra->ListarAsignacion();
    
    ################################# MEMBRETE LETTER #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+40, $this->GetY()+2, 24),5,0,'L');
    $this->Cell(170,5,utf8_decode($con[0]['nominstituto']),5,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-34, $this->GetY()+1, 24),5,0,'L');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"N DE TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(255,10,'LISTADO GENERAL DE ASIGNACIONES DE MATERIAS',0,0,'C');

    if ($_SESSION['acceso'] == "administrador" || $_SESSION["acceso"]=="secretaria") {
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE DOC.',1,0,'C', True);
    $this->Cell(70,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(20,8,'TURNO',1,0,'C', True);
    $this->Cell(20,8,'NIVEL',1,0,'C', True);
    $this->Cell(25,8,'GRADO',1,0,'C', True);
    $this->Cell(20,8,'SECCIN',1,0,'C', True);
    $this->Cell(40,8,'MATERIA',1,0,'C', True);
    $this->Cell(20,8,'PERIODO',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,70,20,20,25,20,40,20));

    if($reg==""){
    echo "";      
    } else {
 
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["ceddoc"]),
        portales(utf8_decode($reg[$i]["nomdoc"])),
        utf8_decode($reg[$i]['turno']),
        utf8_decode($reg[$i]["nivel"]),
        utf8_decode($reg[$i]["grado"]),
        utf8_decode($reg[$i]["seccion"]),
        portales(utf8_decode($reg[$i]["nommateria"])),
        utf8_decode($reg[$i]["periodo"])));
        }
      }
    } else {

    $this->Ln();
    $this->Cell(255,6,"PERIODO ESCOLAR: ".portales(utf8_decode($reg[0]['periodo'])),0,0,'L');
    $this->Ln();
    $this->Cell(255,6,"N DE DOCUMENTO: ".portales(utf8_decode($reg[0]['ceddoc'])),0,0,'L');
    $this->Ln();
    $this->Cell(255,6,"NOMBRE DE DOCENTE: ".portales(utf8_decode($reg[0]['nomdoc'])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'TURNO',1,0,'C', True);
    $this->Cell(70,8,'NIVEL',1,0,'C', True);
    $this->Cell(40,8,'GRADO',1,0,'C', True);
    $this->Cell(25,8,'SECCIN',1,0,'C', True);
    $this->Cell(55,8,'MATERIA',1,0,'C', True);
    $this->Cell(25,8,'PERIODO',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,70,40,25,55,25));

    if($reg==""){
    echo "";      
    } else {
 
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]['turno']),
        utf8_decode($reg[$i]["nivel"]),
        utf8_decode($reg[$i]["grado"]),
        utf8_decode($reg[$i]["seccion"]),
        portales(utf8_decode($reg[$i]["nommateria"])),
        utf8_decode($reg[$i]["periodo"])));
        } 
       }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(70,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(70,6,'',0,0,'');
    $this->Ln(4);
}
################################ FUNCION LISTAR ASIGNACIONES DE MATERIAS A DOCENTES #################################

################################ FUNCION LISTAR ASIGNACIONES DE MATERIAS POR PERIODO #################################
function TablaListarAsignacionesxDocentes()
{
    $tra = new Login();
    $reg = $tra->BuscarMateriasAsignadas();
    
    ################################# MEMBRETE LETTER #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+40, $this->GetY()+2, 24),5,0,'L');
    $this->Cell(170,5,utf8_decode($con[0]['nominstituto']),5,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-34, $this->GetY()+1, 24),5,0,'L');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,"N DE TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(170,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
    ################################# MEMBRETE LETTER #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(255,10,'LISTADO DE ASIGNACIONES DE MATERIAS POR DOCENTE',0,0,'C');

    $this->Ln();
    $this->Cell(255,6,"PERIODO ESCOLAR: ".portales(utf8_decode($reg[0]['periodo'])),0,0,'L');
    $this->Ln();
    $this->Cell(255,6,"N DE DOCUMENTO: ".portales(utf8_decode($reg[0]['ceddoc'])),0,0,'L');
    $this->Ln();
    $this->Cell(255,6,"NOMBRE DE DOCENTE: ".portales(utf8_decode($reg[0]['nomdoc'])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'TURNO',1,0,'C', True);
    $this->Cell(65,8,'NIVEL',1,0,'C', True);
    $this->Cell(45,8,'GRADO',1,0,'C', True);
    $this->Cell(35,8,'SECCIN',1,0,'C', True);
    $this->Cell(65,8,'MATERIA',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,65,45,35,65));

    if($reg==""){
    echo "";      
    } else {
 
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]['turno']),
        utf8_decode($reg[$i]["nivel"]),
        utf8_decode($reg[$i]["grado"]),
        utf8_decode($reg[$i]["seccion"]),
        portales(utf8_decode($reg[$i]["nommateria"]))));
        }
    }
    
    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(70,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(120,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(70,6,'',0,0,'');
    $this->Ln(4);
}
################################ FUNCION LISTAR ASIGNACIONES DE MATERIAS POR PERIODO #################################

################################# FUNCION DOCENTES Y ASIGNACIONES DE MATERIAS #################################



















################################# FUNCION ESTUIDANTES Y PADRES/TUTORES #################################

############################ FUNCION REPORTES DE ESTUDIANTES ##############################
function TablaListarEstudiantesxCursos()
{
	$tra = new Login();
    $reg = $tra->BuscarEstudiantesxCursos();

	################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,10,'LISTADO GENERAL DE ESTUDIANTES POR CURSOS DEL PERIODO '.utf8_decode($reg[0]['periodo']),0,0,'C');

    $this->Ln();
    $this->Cell(330,6,"TURNO: ".portales(utf8_decode($reg[0]['turno'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"NIVEL: ".portales(utf8_decode($reg[0]['nivel'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"GRADO: ".portales(utf8_decode($reg[0]['grado'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"SECCIN: ".portales(utf8_decode($reg[0]['seccion'])),0,0,'L');
	
	$this->Ln(10);
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(40,8,'N DE DOC.',1,0,'C', True);
	$this->Cell(90,8,'APELLIDOS Y NOMBRES',1,0,'C', True);
	$this->Cell(30,8,'SEXO',1,0,'C', True);
	$this->Cell(50,8,'FECHA NACIMIENTO',1,0,'C', True);
	$this->Cell(30,8,'EDAD',1,0,'C', True);
	$this->Cell(55,8,'DIRECCIN DOMICILIARIA',1,0,'C', True);
	$this->Cell(25,8,'BECADO',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,90,30,50,30,55,25));
	
	$a=1;
    for($i=0;$i<sizeof($reg);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["cedest"]),
        portales(utf8_decode($reg[$i]['papeest']." ".$reg[$i]['sapeest']." ".$reg[$i]['pnomest']." ".$reg[$i]['snomest'])),
        utf8_decode($reg[$i]["sexoest"]),
        utf8_decode(date("d-m-Y",strtotime($reg[$i]['fnacest']))),
        edad($reg[$i]["fnacest"])." AOS",
        utf8_decode($reg[$i]["direcest"]),
        utf8_decode($reg[$i]["becado"])));
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
############################ FUNCION REPORTES DE ESTUDIANTES ##############################

############################# FUNCION REPORTES DE TUTORES X CURSOS ##############################
function TablaListarTutoresxCursos()
{
	$tra = new Login();
    $reg = $tra->BuscarTutoresxCursos();

	################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO GENERAL DE PADRES/TUTORES POR CURSOS DEL PERIODO '.utf8_decode($reg[0]['periodo']),0,0,'C');

    $this->Ln();
    $this->Cell(330,6,"TURNO: ".portales(utf8_decode($reg[0]['turno'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"NIVEL: ".portales(utf8_decode($reg[0]['nivel'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"GRADO: ".portales(utf8_decode($reg[0]['grado'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"SECCIN: ".portales(utf8_decode($reg[0]['seccion'])),0,0,'L');
	
	$this->Ln(10);
	$this->SetFont('Courier','B',12);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(36,8,'N DE DOC.',1,0,'C', True);
	$this->Cell(75,8,'APELLIDOS Y NOMBRES',1,0,'C', True);
	$this->Cell(39,8,'N DE TELEFONO',1,0,'C', True);
	$this->Cell(170,8,'DATOS DEL ESTUDIANTE',1,1,'C', True);
 
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,36,75,39,170));
	
	$a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $detalles = str_replace("<br>","\n", $reg[$i]['detalles_alumnos']);

    $this->SetFont('Courier','',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["cedpadre"]),
        portales(utf8_decode($reg[$i]['nompadre']." ".$reg[$i]['apepadre'])),
        utf8_decode($reg[$i]["tlfpadre"]),
        utf8_decode($detalles)));
    }
   
    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION REPORTES DE TUTORES X CURSOS ############################

################################# FUNCION ESTUIDANTES Y PADRES/TUTORES #################################
















###################################### FUNCION PAGOS DE ESTUDIANTES #####################################

############################ FUNCION PARA MOSTRAR COMPROBANTE DE PAGOS ##############################
function TablaComprobantePagos()
{	
	$con = new Login();
	$con = $con->ConfiguracionPorId();
	
	$tra = new Login();
    $reg = $tra->PagosPorId();
	
	//Logo
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $this->Image($logo, 16, 9.5, 17, 17, "PNG");  
   	
	############### BLOQUE DEL MEMBRETE ###################
	//Bloque de membrete principal
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(10, 9, 190, 18, '1.5', '');
	
	//Linea de membrete Nro 1
	$this->SetFont('Courier','BI',9);
    $this->SetXY(38, 10);
    $this->Cell(28, 5, utf8_decode($con[0]['nominstituto']), 0, 0);
    $this->SetXY(130, 10);
    $this->Cell(28, 5, 'N: '.utf8_decode($con[0]['codinstituto']), 0, 0);
	
	//Linea de membrete Nro 2
    $this->SetXY(38, 14);
    $this->Cell(28, 5, utf8_decode($con[0]['direcinstituto']), 0, 0);
    $this->SetXY(130, 14);
    $this->Cell(28, 5, 'FECHA DE PAGO: '.utf8_decode(date("d-m-Y",strtotime($reg[0]['fechapago']))), 0, 0);
    
	//Linea de membrete Nro 3
    $this->SetXY(38, 18);
    $this->Cell(28, 5, 'TLF: '.utf8_decode($con[0]['tlfinstituto']), 0, 0);
    $this->SetXY(130, 18);
    $this->Cell(28, 5, 'CAJA: '.$reg[0]["nrocaja"].": ".$reg[0]["nombrecaja"], 0, 0); //$this->Cell(28, 5, 'USUARIO: '.utf8_decode($_SESSION["usuario"]), 0, 0);
	
	//Linea de membrete Nro 4
    $this->SetXY(38, 22);
    $this->Cell(28, 5, utf8_decode($con[0]['correoinstituto']), 0, 0);
    $this->SetXY(130, 22);
    $this->Cell(28, 5, 'N COMPROBANTE: '.$reg[0]["numcomprobante"], 0, 0);
	$this->Ln(12);
	
	############### BLOQUE DE DATOS PERSONALES DEL TUTOR ###################
	$this->Ln(12);
	$this->SetXY(10, 30);
	$this->SetFont('Courier','B',9);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(189.5,6,'DATOS : PADRE  |  MADRE  |  TUTOR  |  APODERADO',1,0,'L', True);
    $this->Ln();
	//Bloque de membrete principal
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(10, 36, 190, 8, '1.5', '');
	
	//Linea de membrete Nro 3
	$this->SetFont('Courier','B',8);
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetXY(11, 38);
    $this->CellFitSpace(60, 5, 'N DE DOC.: '.utf8_decode($reg[0]["cedpadre"]), 0, 0);
    $this->SetXY(71, 38);
    $this->CellFitSpace(126, 5, 'RAZN SOCIAL: '.utf8_decode($reg[0]["nompadre"]." ".$reg[0]["apepadre"]), 0, 0);
	
	
	############### BLOQUE DE DATOS PERSONALES DEL ESTUDIANTE ###################
	$this->Ln(10);
	$this->SetXY(10, 46);
	$this->SetFont('Courier','B',9);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(189.5,6,'DATOS DEL ESTUDIANTE',1,0,'L', True);
    $this->Ln();
	//Bloque de membrete principal
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(10, 52, 190, 12, '1.5', '');
	
	//Linea de membrete Nro 3
	$this->SetFont('Courier','B',8);
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetXY(11, 54);
    $this->CellFitSpace(34, 5, 'NIVEL: '.utf8_decode($reg[0]["nivel"]), 0, 0);
    $this->SetXY(45, 54);
    $this->CellFitSpace(34, 5, 'GRADO: '.utf8_decode($reg[0]["grado"]), 0, 0);
    $this->SetXY(79, 54);
    $this->CellFitSpace(26, 5, 'SECCIN: '.utf8_decode($reg[0]["seccion"]), 0, 0);
    $this->SetXY(105, 54);
    $this->CellFitSpace(30, 5, 'TURNO: '.utf8_decode($reg[0]["turno"]), 0, 0);
    $this->SetXY(135, 54);
    $this->CellFitSpace(32, 5, 'BECADO: '.utf8_decode($reg[0]["becado"]), 0, 0);
    $this->SetXY(167, 54);
    $this->CellFitSpace(32, 5, 'PERIODO: '.utf8_decode($reg[0]["periodo"]), 0, 0);
	
	$this->SetXY(11, 59);
    $this->CellFitSpace(60, 5, 'N DE DOC.: '.utf8_decode($reg[0]["cedest"]), 0, 0);
    $this->SetXY(71, 59);
    $this->CellFitSpace(126, 5, 'NOMBRES Y APELLIDOS: '.utf8_decode($reg[0]["pnomest"]." ".$reg[0]["snomest"]." ".$reg[0]["papeest"]." ".$reg[0]["sapeest"]), 0, 0);
	
	//Bloque de datos de empresa
    $this->SetFillColor(5, 130, 275);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(10, 66, 190, 8, '1.5', 'F');
	
	$this->SetFillColor(5, 130, 275);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(10, 66, 190, 8, '1.5', '');

   if($reg==""){

    echo "";
    exit();

    } else {
    
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetXY(10, 67.5);
    $this->Cell(10, 5, 'N', 0, 0,'C');
    $this->SetXY(20, 67.5);
    $this->Cell(120, 5, 'DESCRIPCIN', 0, 0, 'C');
    $this->SetXY(140, 67.5);
    $this->Cell(30, 5, 'VALOR UNIT', 0, 0, 'C');
    $this->SetXY(170, 67.5);
    $this->Cell(30, 5, 'IMPORTE', 0, 0, 'C');
    
    $this->Ln();
    $this->SetXY(10, 74);

    $a=1;
    $PagoTotal=0;
    $explode = explode("<br>",$reg[0]['detalles_meses2']);
    for($cont=0; $cont<COUNT($explode); $cont++):
    list($meses,$monto) = explode("|",$explode[$cont]);
    //for($i=0;$i<sizeof($reg);$i++){
    //$PagoTotal+=$reg[$i]["montopago"];
    //$desc=$reg[0]['descuento']/100;

    $this->SetFont('Courier','',9);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(10,5,$a++,1,0,'C');
    $this->Cell(110,5,"PAGO DE CUOTA CORRESPONDIENTE AL MES DE ".convertir($meses),1,0,'C');
    $this->Cell(35,5,utf8_decode(number_format($monto, 2, '.', ',')),1,0,'C');
    $this->Cell(35,5,utf8_decode(number_format($monto, 2, '.', ',')),1,0,'C');
    $this->Ln();

    endfor;

    $this->SetFont('Courier','B',9);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'FECHA: '.utf8_decode(date("d-m-Y H:i:s")),0,0,'L');
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(35,5,'SUBTOTAL',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,number_format($reg[0]["subtotal"], 2, '.', ','),1,0,'C');
    $this->Ln();

    if(!empty($reg[0]["montoinscripcion"]) && $reg[0]["montoinscripcion"] != '0.00'){
    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'MONTO INSCRIPCIN',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,utf8_decode($cuota = ($reg[0]["montoinscripcion"] == '' ? "0.00" : number_format($reg[0]["montoinscripcion"], 2, '.', ','))),1,0,'C');
    $this->Ln();
    }

    if(!empty($reg[0]["cuotaunica"]) && $reg[0]["cuotaunica"] != '0.00'){
    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'CUOTA UNICA',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,utf8_decode($cuota = ($reg[0]["cuotaunica"] == '' ? "0.00" : number_format($reg[0]["cuotaunica"], 2, '.', ','))),1,0,'C');
    $this->Ln();
    }

    if(!empty($reg[0]["montomesextra"]) && $reg[0]["montomesextra"] != '0.00'){
    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'MONTO MESES EXTRA',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,utf8_decode($monto = ($reg[0]["montomesextra"] == '' ? "0.00" : number_format($reg[0]["montomesextra"], 2, '.', ','))),1,0,'C');
    $this->Ln();
    }

    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'DESC X CUOTA '.number_format($reg[0]['descuento'], 2, '.', ',').' %',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->CellFitSpace(35,5,utf8_decode(number_format($reg[0]["totaldescuento"], 2, '.', ',')),1,0,'C');
    $this->Ln();

    if(!empty($reg[0]["totalpendiente"]) || !empty($reg[0]["totalpagada"])){

    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'CUOTAS VENC. PEND.',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,utf8_decode($reg[0]["totalpendiente"]),1,0,'C');
    $this->Ln();

    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'CUOTAS VENC. PAG.',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->Cell(35,5,utf8_decode($reg[0]["totalpagada"]),1,0,'C');
    $this->Ln();
    
    $this->SetFont('Courier','B',7);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)$this->Cell(10,5,'',1,0,'C');
    $this->Cell(120,5,'',0,0,'C');
    $this->CellFitSpace(35,5,'INTERS POR MORA',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL 
    $this->CellFitSpace(35,5,number_format($reg[0]["totalintereses"], 2, '.', ','),1,0,'C');
    $this->Ln();
    }
    
    $this->SetFont('Courier','B',9);  
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(120,5,'',0,0,'C');
    $this->SetFont('Courier','B',7);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(35,5,'TOTAL A PAGAR',1,0,'C', True);
    $this->SetFont('Courier','B',9);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->CellFitSpace(35,5,utf8_decode(number_format($reg[0]["totalpago"], 2, '.', ',')),1,0,'C');
    $this->Ln();

    }
   
    $this->Ln(6);
	$this->SetFont('Courier','B',7);
    $this->Cell(190,0,'RECORTAR - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ','',1,'C');
    $this->Ln(4);
}
############################ FUNCION PARA MOSTRAR COMPROBANTE DE PAGOS ##############################

######################### FUNCION PARA MOSTRAR PAGOS POR FECHAS ###########################
function TablaListarPagosxFechas()
{
	$reg = new Login();
    $reg = $reg->BuscarPagosxFechas();

    $egreso = new Login();
    $egreso = $egreso->SumaGastosFechas();

	################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,8,'LISTADO GENERAL DE PAGOS POR FECHAS',0,0,'C');

    $this->Ln();
    $this->Cell(330,6,"PERIODO: ".utf8_decode($reg[0]['periodo']),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"DESDE: ".date("d-m-Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"HASTA: ".date("d-m-Y", strtotime($_GET["hasta"])),0,0,'L');
	
	$this->Ln(10);
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(60,8,'NOMBRES DE ESTUDIANTE',1,0,'C', True);
	$this->Cell(28,8,'NIVEL',1,0,'C', True);
	$this->Cell(29,8,'GRADO/SECC',1,0,'C', True);
	$this->Cell(20,8,'BECADO',1,0,'C', True);
    $this->Cell(50,8,'MESES PAGADOS',1,0,'C', True);
	$this->Cell(22,8,'MONTO',1,0,'C', True);
	$this->Cell(22,8,'C. UNICA',1,0,'C', True);
    $this->Cell(22,8,'INTERESES',1,0,'C', True);
    $this->Cell(22,8,'DESCUENTO',1,0,'C', True);
	$this->Cell(36,8,'PAGO TOTAL',1,1,'C', True);

    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,60,28,29,20,50,22,22,22,22,36));
	
	$a=1;
	$PagoTotal=0;
	for($i=0;$i<sizeof($reg);$i++){ 
	$PagoTotal  += $reg[$i]['totalpago'];

	$this->SetFont('Courier','',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        portales(utf8_decode($reg[$i]["cedest"].": ".$reg[$i]['pnomest']." ".$reg[$i]['snomest']." ".$reg[$i]['papeest']." ".$reg[$i]['sapeest'])),
        utf8_decode($reg[$i]["nivel"]),
        utf8_decode($reg[$i]["grado"]."/".$reg[$i]["seccion"]),
        utf8_decode($reg[$i]["becado"]),
        utf8_decode(convertir2($reg[$i]["mesespag"])),
        utf8_decode(number_format($reg[$i]['montopago'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['cuotaunica'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['totalintereses'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['totaldescuento'], 2, '.', ',')),
        utf8_decode(number_format($reg[$i]['totalpago'], 2, '.', ','))));
    }

    $this->SetFont('Courier','B',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(251,5,'',0,0,'C');
	$this->Cell(34,5,'MONTO TOTAL',0,0,'L');
	$this->Cell(36,5,utf8_decode(number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->SetFont('Courier','B',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(251,5,'',0,0,'C');
	$this->Cell(34,5,'EGRESOS',0,0,'L');
	$this->Cell(30,5,utf8_decode(number_format($egreso[0]['egresos'], 2, '.', ',')),0,0,'L');
    $this->Ln();

    $this->SetFont('Courier','B',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(251,5,'',0,0,'C');
	$this->Cell(34,5,'TOTAL GEN.',0,0,'L');
	$this->Cell(30,5,utf8_decode(number_format($PagoTotal-$egreso[0]['egresos'], 2, '.', ',')),0,0,'L');
    $this->Ln();
   
    $this->Ln(12); 
    $this->SetFont('courier','B',12);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(120,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(120,6,'',0,0,'');
    $this->Ln(4);
}
######################### FUNCION PARA MOSTRAR PAGOS POR FECHAS ###########################

######################### FUNCION PARA MOSTRAR PAGOS AL DIA ############################
function TablaListarPagosAlDia()
{
	$reg = new Login();
    $reg = $reg->BuscarPagosAlDia();
	
	################################# MEMBRETE A4 #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");
    
    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+14, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()+8, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,portales(utf8_decode($con[0]['direcinstituto'])),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(100,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(8);
    ################################# MEMBRETE A4 #################################

	$this->SetFont('Courier','B',12);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(190,8,'LISTADO DE PAGOS AL DA POR CURSOS AL MES',0,0,'C');

    $this->Ln();
    $this->Cell(190,5,"TURNO: ".portales(utf8_decode($reg[0]['turno'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"NIVEL: ".portales(utf8_decode($reg[0]['nivel'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"GRADO: ".portales(utf8_decode($reg[0]['grado'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"SECCIN: ".portales(utf8_decode($reg[0]['seccion'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"PERIODO: ".portales(utf8_decode($reg[0]['periodo'])),0,0,'L');
    $this->Ln();
    $this->Cell(190,5,"MES: ".convertir($_GET['mespago']),0,0,'L');
	
	$this->Ln(10);
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(30,8,'N DE DOC.',1,0,'C', True);
	$this->Cell(70,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
	$this->Cell(25,8,'BECADO',1,0,'C', True);
	$this->Cell(25,8,'CUOTA MES',1,0,'C', True);
	$this->Cell(30,8,'FECHA PAGADO',1,1,'C', True);

    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,70,25,25,30));
	
	$a=1;
	$pagoTotal=0;
	for($i=0;$i<sizeof($reg);$i++){

	$this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["cedula"]),
        portales(utf8_decode($reg[$i]['pNombre']." ".$reg[$i]['sNombre']." ".$reg[$i]['pApellido']." ".$reg[$i]['sApellido'])),
        utf8_decode($reg[$i]["becado"]),
        utf8_decode(number_format($reg[$i]["montopago"], 2, '.', ',')),
        utf8_decode(date("d-m-Y",strtotime($reg[$i]['fechapago'])))));
    }
   
    $this->Ln(12); 
    $this->SetFont('courier','B',9);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(60,6,'RECIBIDO:__________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(60,6,'',0,0,'');
    $this->Ln(4);
}
######################### FUNCION PARA MOSTRAR PAGOS AL DIA ############################

####################### FUNCION PARA MOSTRAR PAGOS VENCIDOS POR CURSOS ######################
function TablaListarPagosVencidosxCursos()
{
    $reg = new Login();
    $reg = $reg->BuscarPagosVencidosxCursos();
	
	################################# MEMBRETE LEGAL #################################
	$logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

	$this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
	################################# MEMBRETE LEGAL #################################
	
	$this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(330,10,'LISTADO DE PAGOS VENCIDOS POR CURSOS',0,0,'C');
	
	$this->Ln();
    $this->Cell(330,6,"PERIODO: ".portales(utf8_decode($reg[0]['periodo'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"TURNO: ".portales(utf8_decode($reg[0]['turno'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"NIVEL: ".portales(utf8_decode($reg[0]['nivel'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"GRADO: ".portales(utf8_decode($reg[0]['grado'])),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"SECCIN: ".portales(utf8_decode($reg[0]['seccion'])),0,0,'L');

    $this->Ln(10);
	$this->SetFont('Courier','B',10);
	$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
	$this->Cell(10,8,'N',1,0,'C', True);
	$this->Cell(30,8,'N DE DOC.',1,0,'C', True);
	$this->Cell(65,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
	$this->Cell(25,8,'BECADO',1,0,'C', True);
	$this->Cell(60,8,'MESES VENCIDOS',1,0,'C', True);
    $this->Cell(30,8,'INTERES',1,0,'C', True);
    $this->Cell(30,8,'CUOTA MES',1,0,'C', True);
	$this->Cell(40,8,'MONTO INTERS',1,0,'C', True);
	$this->Cell(40,8,'PAGO TOTAL',1,1,'C', True);

    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,65,25,60,30,30,40,40));
	
	$a=1;
    $PagoInteres = 0;
    $PagoTotal   = 0;
    for($i=0;$i<sizeof($reg);$i++){

    $Interes  = ($reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos'])); 
    $Total  = ($reg[$i]['montopago']+$reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos']));

    $PagoInteres += $Interes; 
    $PagoTotal += $Total;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["cedula"]),
        portales(utf8_decode($reg[$i]['pNombre']." ".$reg[$i]['sNombre']." ".$reg[$i]['pApellido']." ".$reg[$i]['sApellido'])),
        utf8_decode($reg[$i]["becado"]),
        utf8_decode(convertir2($reg[$i]["mesesvencidos"])),
        utf8_decode($reg[$i]["interesmora"]),
        utf8_decode($reg[$i]["montopago"]),
        utf8_decode(number_format($Interes, 2, '.', ',')),
        utf8_decode(number_format($Total, 2, '.', ','))));
    }
   
    $this->SetFont('Courier','B',10);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(220,5,'',0,0,'C');
	$this->Cell(30,5,'MONTO TOTAL',0,0,'L');
    $this->Cell(40,5,utf8_decode(number_format($PagoInteres, 2, '.', ',')),0,0,'L');
	$this->Cell(40,5,utf8_decode(number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   
    $this->Ln(12); 
    $this->SetFont('Courier','B',12);
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(120,6,'RECIBIDO POR:______________________________________________',0,0,'');
    $this->Ln();
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(120,6,'',0,0,'');
    $this->Ln(11);
}
####################### FUNCION PARA MOSTRAR PAGOS VENCIDOS ######################

####################### FUNCION PARA MOSTRAR PAGOS VENCIDOS POR CURSOS POR PERIODO ######################
function TablaListarPagosVencidosxPeriodo()
{
    $reg = new Login();
    $reg = $reg->BuscarPagosVencidosxPeriodo();
    
    ################################# MEMBRETE LEGAL #################################
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $logo2 = (file_exists("./fotos/logo_pdf.png") == "" ? "./assets/images/null.png" : "./fotos/logo_pdf.png");

    $con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $this->Ln(2);
    $this->SetFont('Courier','B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(45,5,$this->Image($logo, $this->GetX()+79, $this->GetY()+1, 24),0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['nominstituto']),0,0,'C');
    $this->Cell(45,5,$this->Image($logo2, $this->GetX()-50, $this->GetY()+1, 24),0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['codinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['direcinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,"TLF: ".utf8_decode($con[0]['tlfinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(45,5,"",0,0,'C');
    $this->Cell(240,5,utf8_decode($con[0]['correoinstituto']),0,0,'C');
    $this->Cell(45,5,"",0,0,'C');
    $this->Ln(10);
    ################################# MEMBRETE LEGAL #################################
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE PAGOS VENCIDOS POR PERIODO',0,0,'C');
    
    $this->Ln();
    $this->Cell(330,6,"PERIODO: ".portales(utf8_decode($reg[0]['periodo'])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(5, 130, 275); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE DOC.',1,0,'C', True);
    $this->Cell(65,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(25,8,'BECADO',1,0,'C', True);
    $this->Cell(60,8,'MESES VENCIDOS',1,0,'C', True);
    $this->Cell(30,8,'INTERES',1,0,'C', True);
    $this->Cell(30,8,'CUOTA MES',1,0,'C', True);
    $this->Cell(40,8,'MONTO INTERS',1,0,'C', True);
    $this->Cell(40,8,'PAGO TOTAL',1,1,'C', True);

    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,65,25,60,30,30,40,40));
    
    $a=1;
    $PagoInteres = 0;
    $PagoTotal   = 0;
    for($i=0;$i<sizeof($reg);$i++){

    $Interes  = ($reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos'])); 
    $Total  = ($reg[$i]['montopago']+$reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos']));

    $PagoInteres += $Interes; 
    $PagoTotal += $Total;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        utf8_decode($reg[$i]["cedula"]),
        portales(utf8_decode($reg[$i]['pNombre']." ".$reg[$i]['sNombre']." ".$reg[$i]['pApellido']." ".$reg[$i]['sApellido'])),
        utf8_decode($reg[$i]["becado"]),
        utf8_decode(convertir2($reg[$i]["mesesvencidos"])),
        utf8_decode($reg[$i]["interesmora"]),
        utf8_decode($reg[$i]["montopago"]),
        utf8_decode(number_format($Interes, 2, '.', ',')),
        utf8_decode(number_format($Total, 2, '.', ','))));
    }
   
    $this->SetFont('Courier','B',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(220,5,'',0,0,'C');
    $this->Cell(30,5,'MONTO TOTAL',0,0,'L');
    $this->Cell(40,5,utf8_decode(number_format($PagoInteres, 2, '.', ',')),0,0,'L');
    $this->Cell(40,5,utf8_decode(number_format($PagoTotal, 2, '.', ',')),0,0,'L');
    $this->Ln();
   
    $this->Ln(12); 
    $this->SetFont('Courier','B',12);
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'ELABORADO POR: '.utf8_decode($_SESSION["nombres"]),0,0,'');
    $this->Cell(120,6,'RECIBIDO POR:______________________________________________',0,0,'');
    $this->Ln();
    $this->Cell(30,6,'',0,0,'');
    $this->Cell(160,6,'FECHA/HORA ELABORACIN:  '.date('d-m-Y H:i:s'),0,0,'');
    $this->Cell(120,6,'',0,0,'');
    $this->Ln(11);
}
####################### FUNCION PARA MOSTRAR PAGOS VENCIDOS POR PERIODO ######################

############################# FUNCION PARA MOSTRAR AVISO DE COBRANZA #############################
function TablaCobranza()
{
	$reg = new Login();
    $reg = $reg->BuscarPagosVencidosxCursos();
	
	$con = new Login();
    $con = $con->ConfiguracionPorId(); 

    $a=1;
    $PagoInteres = 0;
    $PagoTotal   = 0;
    for($i=0;$i<sizeof($reg);$i++){

    $Interes  = ($reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos'])); 
    $Total  = ($reg[$i]['montopago']+$reg[$i]['interesmora'])*count(explode(", ",$reg[$i]['mesesvencidos']));

    $PagoInteres += $Interes; 
    $PagoTotal += $Total;

    $this->SetFont('Courier','B',14);  
	$this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
	$this->Cell(190,0,'AVISO DE COBRANZA',0,1,'C');
	$this->SetFont('Courier','B',8);
	$this->Cell(190,0,'FECHA IMPRESIN '. date("d-m-Y"),0,0,'R');
	$this->Ln(5);

    $this->newFlowingBlock( 188, 5, 0, 'J' );
	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock('HACEMOS RECUERDO A USTED POR FAVOR PASAR POR SECRETARA A CANCELAR LA(S) CUOTA(S) DE ');

    $this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode(convertir($reg[$i]["mesesvencidos"])));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(' DE SU HIJO(A) ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode($reg[$i]['pNombre']." ".$reg[$i]['sNombre']." ".$reg[$i]['pApellido']." ".$reg[$i]['sApellido']));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(', DEL ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode($reg[$i]['grado'].' '.$reg[$i]['seccion']));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(' DE ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode($reg[$i]['nivel']));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(' TURNO ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode($reg[$i]['turno']));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(' DEL PERIODO ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode($reg[$i]['periodo']));

	$this->SetFont( 'Arial', '', 8 );
	$this->WriteFlowingBlock(' HACIENDO UN TOTAL DE ');

	$this->SetFont( 'Arial', 'B', 8 );
	$this->WriteFlowingBlock(utf8_decode(number_format($Total, 2, '.', ',')).' BS.');

	$this->finishFlowingBlock();
	$this->Ln();

	$this->SetFont('Courier','B',10);
	$this->Cell(190,0,'LA DIRECCIN',0,0,'C');
	$this->Ln(10);
	
    //$this->AddPage();
    }
}
############################# FUNCION PARA MOSTRAR AVISO DE COBRANZA #############################

###################################### FUNCION PAGOS DE ESTUDIANTES #####################################























###################################### FUNCION NOTAS DE ESTUDIANTES #####################################

############################# FUNCION PARA MOSTRAR BOLETIN #############################
function TablaBoletin()
{
    //Logo
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $this->Image($logo , 20, 10, 24, 24, "PNG");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId();
    $TipoLetra = "Arial"; 
   
	$codest = $_GET['codest'];	
    $nota = new Login();
    $nota = $nota->BuscarNotasEstudiantes();

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"DEPARTAMENTO DEL CAUCA", 0, 1, 'C');

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"MUNICIPIO DE PAEZ", 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,portales(utf8_decode($con[0]['nominstituto'])), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"CODIGO DANE ".portales("N. ".utf8_decode($con[0]['codinstituto'])), 0, 1, 'C');

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"RESOLUCION 0446-04-2.004 - 03512-04-2.013 Y 01205-02-2.019", 0, 1, 'C');
    $this->Ln();

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"BOLETN ACADMICO DE ".utf8_decode($nota[0]['nivel']), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(190, 4,"FECHA: ".date("d")." DE ".convertir(date("m"))." DEL ".date("Y"), 0, 1, 'R'); //Membrete Nro 1
    $this->Ln(2);

    $this->SetFont($TipoLetra,'',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(32, 5,"AO LECTIVO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($nota[0]['periodo']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(52, 5,"NIVEL DE ESCOLARIDAD:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(32, 5,utf8_decode($nota[0]['nivel']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(25, 5,"GRADO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($nota[0]['grado']), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(32, 5,"CALENDARIO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,"A", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(52, 5,"JORNADA:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(32, 5,utf8_decode($nota[0]['turno']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(25, 5,"PERIODO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($con[0]['trimestreactivo']), 0, 1, 'L');
    $this->Ln(2);

    $this->SetFont($TipoLetra,'',9);
    $this->MultiAlignCell2(45, 12,"NOMBRES Y APELLIDOS DEL ESTUDIANTE", 1, 0, 'C');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(90, 12,portales(utf8_decode($nota[0]['pnomest']." ".$nota[0]['snomest']." ".$nota[0]['papeest']." ".$nota[0]['sapeest'])), 1, 0, 'C');
    $this->SetFont($TipoLetra,'',9);
    $this->Cell(25, 12,"PUESTO:", 1, 0, 'L');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(30, 12,utf8_decode($puesto = ($nota[0]['puesto'] == 0 ? "" : $nota[0]['puesto'])), 1, 1, 'C');

    $this->SetFont($TipoLetra,'',9);
    $this->MultiAlignCell2(45, 12,"NMERO DE DOCUMENTO DE IDENTIDAD", 1, 0, 'C');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(90, 12,portales(utf8_decode($nit = ($nota[0]['cedest'] == "" ? "-" : $nota[0]['cedest']))), 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'',9);
    $this->Cell(25, 12,"PROMEDIO:", 1, 0, 'L');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(30, 12,utf8_decode($definitiva = ($nota[0]['nota_definitiva'])), 1, 1, 'C');
    $this->Ln(4);

    if($nota[0]['nivel'] == 'INICIAL' OR $nota[0]['nivel'] == 'PREESCOLAR'){//inicio tipo de nivel

     $this->SetFont($TipoLetra,'B',10);
    $this->Cell(59, 8,"DIMENSIONES", 1, 0, 'C'); 
    $this->Cell(80, 8,"", 1, 0, 'C');  
    $this->Cell(51, 8,"CONCEPTO FINAL", 1, 1, 'C');

    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(59, 8,"", 1, 0, 'C'); 
    $this->Cell(10, 8,"I", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"II", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"III", 1, 0, 'C');
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"IV", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'B',7);
    $this->Cell(20, 8,"CUANTITATIVO", 1, 0, 'C'); 
    $this->Cell(21, 8,"CUALITATIVO", 1, 0, 'C'); 
    $this->Cell(10, 8,"T FALT", 1, 1, 'C');

    $this->SetWidths(array(59,10,10,10,10,10,10,10,10,20,21,10));
    $this->SetAligns(Array('J','C','C','C','C','C','C','C','C','C','L','C'));

    $SumaTotal=0;
    for($i=0;$i<sizeof($nota);$i++){ 
    $array[] = $nota[$i]['definitiva'];
    $TotalDef=count($array);
    $SumaTotal+=$nota[$i]['definitiva'];

	$definitiva = ($nota[$i]['definitiva']);
	if($nota[$i]['definitiva'] == 0 ){
		$desempeno = "";
	} else if($nota[$i]['definitiva'] >= 0.1 && $nota[$i]['definitiva'] <= 2.9){
		$desempeno = "DES. BAJO";
	} else if($nota[$i]['definitiva'] >= 3.0 && $nota[$i]['definitiva'] <= 3.9){
		$desempeno = "DES. BSICO";
	} else if($nota[$i]['definitiva'] >= 4.0 && $nota[$i]['definitiva'] <= 4.9){
		$desempeno = "DES. ALTO";
	} else if($nota[$i]['definitiva'] >= 5.0){
		$desempeno = "DES. SUPERIOR";
	}

    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Row(array(
        portales(utf8_decode($nota[$i]['nommateria'])),
        utf8_decode($nota[$i]["nota1"]),
        utf8_decode($nota[$i]["faltas1"]),
        utf8_decode($nota[$i]["nota2"]),
        utf8_decode($nota[$i]["faltas2"]),
        utf8_decode($nota[$i]["nota3"]),
        utf8_decode($nota[$i]["faltas3"]),
        utf8_decode($nota[$i]["nota4"]),
        utf8_decode($nota[$i]["faltas4"]),
        portales(utf8_decode($definitiva)),
        portales($desempeno),
        portales($nota[$i]['total_faltas'])));
    }



    } else {

    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(28, 8,"AREAS", 1, 0, 'C'); 
    $this->Cell(47, 8,"ASIGNATURAS", 1, 0, 'C'); 
    $this->Cell(64, 8,"", 1, 0, 'C');  
    $this->Cell(51, 8,"CONCEPTO FINAL", 1, 1, 'C');

    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(28, 8,"", 1, 0, 'C'); 
    $this->Cell(47, 8,"", 1, 0, 'C'); 
    $this->Cell(8, 8,"I", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"II", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"III", 1, 0, 'C');
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"IV", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'B',7);
    $this->Cell(20, 8,"CUANTITATIVO", 1, 0, 'C'); 
    $this->Cell(21, 8,"CUALITATIVO", 1, 0, 'C'); 
    $this->Cell(10, 8,"T FALT", 1, 1, 'C');

    $this->SetWidths(array(28,47,8,8,8,8,8,8,8,8,20,21,10));
    $this->SetAligns(Array('C','J','C','C','C','C','C','C','C','C','C','L','C'));

    $SumaTotal=0;
    for($i=0;$i<sizeof($nota);$i++){ 
    $array[] = $nota[$i]['definitiva'];
    $TotalDef=count($array);
    $SumaTotal+=$nota[$i]['definitiva'];

	$definitiva = ($nota[$i]['definitiva']);
	if($nota[$i]['definitiva'] == 0){
		$desempeno = "";
	} else if($nota[$i]['definitiva'] >= 0.1 && $nota[$i]['definitiva'] <= 2.9){
		$desempeno = "DES. BAJO";
	} else if($nota[$i]['definitiva'] >= 3.0 && $nota[$i]['definitiva'] <= 3.9){
		$desempeno = "DES. BSICO";
	} else if($nota[$i]['definitiva'] >= 4.0 && $nota[$i]['definitiva'] <= 4.9){
		$desempeno = "DES. ALTO";
	} else if($nota[$i]['definitiva'] >= 5.0){
		$desempeno = "DES. SUPERIOR";
	}

    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Row(array(
        portales(utf8_decode($nota[$i]['nomarea'])),
        portales(utf8_decode($nota[$i]['nommateria'])),
        utf8_decode($nota[$i]["nota1"]),
        utf8_decode($nota[$i]["faltas1"]),
        utf8_decode($nota[$i]["nota2"]),
        utf8_decode($nota[$i]["faltas2"]),
        utf8_decode($nota[$i]["nota3"]),
        utf8_decode($nota[$i]["faltas3"]),
        utf8_decode($nota[$i]["nota4"]),
        utf8_decode($nota[$i]["faltas4"]),
        portales(utf8_decode($definitiva)),
        portales($desempeno),
        portales($nota[$i]['total_faltas'])));
    }

    }//fin tipo de nivel

    //$this->Ln();
    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(28, 14,"OBSERVACIONES", 1, 0, 'C');
    $this->SetFont($TipoLetra,'',11);
    $this->Cell(162, 14," ", 1, 1, 'L');

    $this->SetFont($TipoLetra,'B',9);
    $this->Cell(190, 6,portales("ESCALA DE VALORACIN: SUPERIOR: 5:00 - ALTO: 4.0 A 4.9 - BSICO: 3.0 A 3.9 -  BAJO: 1.0 A 2.9"), 1, 1, 'C');
    $this->Ln();

    $firma = (file_exists("./fotos/firma.png") == "" ? "./assets/images/null.png" : "./fotos/firma.png");
    $this->Image($firma, 150, 250, 30);

    $this->SetXY(10,264);
	$this->SetTextColor(3, 3, 3);  // Establece el color del texto (en este caso es blanco) 
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(85,6,'___________________________',0,0,'C');
    $this->Cell(20,6,'',0,0,'C');
    $this->Cell(85,6,'___________________________',0,0,'C');

    $this->SetXY(10,270);
    //$this->SetXY(10,-28);
	$this->SetTextColor(3, 3, 3);  // Establece el color del texto (en este caso es blanco) 
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(85,6,'DIRECTOR(A) GRADO',0,0,'C');
    $this->Cell(20,6,'',0,0,'C');
    $this->Cell(85,6,'RECTOR',0,1,'C');
}
############################# FUNCION PARA MOSTRAR BOLETIN #############################

############################# FUNCION PARA MOSTRAR BOLETIN POR PERIODOS #############################
function TablaBoletaxPeriodo()
{
    //Logo
    $logo = (file_exists("./fotos/logo_principal.png") == "" ? "./assets/images/null.png" : "./fotos/logo_principal.png");
    $this->Image($logo , 20, 10, 24, 24, "PNG");
	
	$con = new Login();
    $con = $con->ConfiguracionPorId();
    $TipoLetra = "Arial"; 
   
	$codest = $_GET['codest'];	
    $nota = new Login();
    $nota = $nota->BuscarNotasxPeriodos();

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"DEPARTAMENTO DEL CAUCA", 0, 1, 'C');

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"MUNICIPIO DE PAEZ", 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,portales(utf8_decode($con[0]['nominstituto'])), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"CODIGO DANE ".portales("N. ".utf8_decode($con[0]['codinstituto'])), 0, 1, 'C');

	$this->SetFont($TipoLetra,'B',11);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"RESOLUCION 0446-04-2.004 - 03512-04-2.013 Y 01205-02-2.019", 0, 1, 'C');
    $this->Ln();

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(190, 5,"BOLETN ACADMICO DE ".utf8_decode($nota[0]['nivel']), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(190, 4,"FECHA: ".date("d")." DE ".convertir(date("m"))." DEL ".date("Y"), 0, 1, 'R'); //Membrete Nro 1
    $this->Ln(2);

    $this->SetFont($TipoLetra,'',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(32, 5,"AO LECTIVO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($nota[0]['periodo']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(52, 5,"NIVEL DE ESCOLARIDAD:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(32, 5,utf8_decode($nota[0]['nivel']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(25, 5,"GRADO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($nota[0]['grado']), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(32, 5,"CALENDARIO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,"A", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(52, 5,"JORNADA:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(32, 5,utf8_decode($nota[0]['turno']), 0, 0, 'L');
    $this->SetFont($TipoLetra,'',10);
    $this->Cell(25, 5,"PERIODO:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(22, 5,utf8_decode($con[0]['trimestreactivo']), 0, 1, 'L');
    $this->Ln(2);

    $this->SetFont($TipoLetra,'',9);
    $this->MultiAlignCell2(45, 12,"NOMBRES Y APELLIDOS DEL ESTUDIANTE", 1, 0, 'C');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(90, 12,portales(utf8_decode($nota[0]['pnomest']." ".$nota[0]['snomest']." ".$nota[0]['papeest']." ".$nota[0]['sapeest'])), 1, 0, 'C');
    $this->SetFont($TipoLetra,'',9);
    $this->Cell(25, 12,"PUESTO:", 1, 0, 'L');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(30, 12,utf8_decode($puesto = ($nota[0]['puesto'] == 0 ? "" : $nota[0]['puesto'])), 1, 1, 'C');

    $this->SetFont($TipoLetra,'',9);
    $this->MultiAlignCell2(45, 12,"NMERO DE DOCUMENTO DE IDENTIDAD", 1, 0, 'C');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(90, 12,portales(utf8_decode($nit = ($nota[0]['cedest'] == "" ? "-" : $nota[0]['cedest']))), 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'',9);
    $this->Cell(25, 12,"PROMEDIO:", 1, 0, 'L');
    $this->SetFont($TipoLetra,'B',11);
    $this->Cell(30, 12,utf8_decode($definitiva = ($nota[0]['nota_definitiva'])), 1, 1, 'C');
    $this->Ln(4);

    if($nota[0]['nivel'] == 'INICIAL' OR $nota[0]['nivel'] == 'PREESCOLAR'){//inicio tipo de nivel

     $this->SetFont($TipoLetra,'B',10);
    $this->Cell(59, 8,"DIMENSIONES", 1, 0, 'C'); 
    $this->Cell(80, 8,"", 1, 0, 'C');  
    $this->Cell(51, 8,"CONCEPTO FINAL", 1, 1, 'C');

    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(59, 8,"", 1, 0, 'C'); 
    $this->Cell(10, 8,"I", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"II", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"III", 1, 0, 'C');
    $this->Cell(10, 8,"FAL", 1, 0, 'C');
    $this->Cell(10, 8,"IV", 1, 0, 'C'); 
    $this->Cell(10, 8,"FAL", 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'B',7);
    $this->Cell(20, 8,"CUANTITATIVO", 1, 0, 'C'); 
    $this->Cell(21, 8,"CUALITATIVO", 1, 0, 'C'); 
    $this->Cell(10, 8,"T FALT", 1, 1, 'C');

    $this->SetWidths(array(59,10,10,10,10,10,10,10,10,20,21,10));
    $this->SetAligns(Array('J','C','C','C','C','C','C','C','C','C','L','C'));

    $SumaTotal=0;
    for($i=0;$i<sizeof($nota);$i++){ 
    $array[] = $nota[$i]['definitiva'];
    $TotalDef=count($array);
    $SumaTotal+=$nota[$i]['definitiva'];

	$definitiva = ($nota[$i]['definitiva']);
	if($nota[$i]['definitiva'] == 0 ){
		$desempeno = "";
	} else if($nota[$i]['definitiva'] >= 0.1 && $nota[$i]['definitiva'] <= 2.9){
		$desempeno = "DES. BAJO";
	} else if($nota[$i]['definitiva'] >= 3.0 && $nota[$i]['definitiva'] <= 3.9){
		$desempeno = "DES. BSICO";
	} else if($nota[$i]['definitiva'] >= 4.0 && $nota[$i]['definitiva'] <= 4.9){
		$desempeno = "DES. ALTO";
	} else if($nota[$i]['definitiva'] >= 5.0){
		$desempeno = "DES. SUPERIOR";
	}

    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Row(array(
        portales(utf8_decode($nota[$i]['nommateria'])),
        utf8_decode($nota[$i]["nota1"]),
        utf8_decode($nota[$i]["faltas1"]),
        utf8_decode($nota[$i]["nota2"]),
        utf8_decode($nota[$i]["faltas2"]),
        utf8_decode($nota[$i]["nota3"]),
        utf8_decode($nota[$i]["faltas3"]),
        utf8_decode($nota[$i]["nota4"]),
        utf8_decode($nota[$i]["faltas4"]),
        portales(utf8_decode($definitiva)),
        portales($desempeno),
        portales($nota[$i]['total_faltas'])));
    }



    } else {

    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(28, 8,"AREAS", 1, 0, 'C'); 
    $this->Cell(47, 8,"ASIGNATURAS", 1, 0, 'C'); 
    $this->Cell(64, 8,"", 1, 0, 'C');  
    $this->Cell(51, 8,"CONCEPTO FINAL", 1, 1, 'C');

    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(28, 8,"", 1, 0, 'C'); 
    $this->Cell(47, 8,"", 1, 0, 'C'); 
    $this->Cell(8, 8,"I", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"II", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"III", 1, 0, 'C');
    $this->Cell(8, 8,"FAL", 1, 0, 'C');
    $this->Cell(8, 8,"IV", 1, 0, 'C'); 
    $this->Cell(8, 8,"FAL", 1, 0, 'C'); 
    $this->SetFont($TipoLetra,'B',7);
    $this->Cell(20, 8,"CUANTITATIVO", 1, 0, 'C'); 
    $this->Cell(21, 8,"CUALITATIVO", 1, 0, 'C'); 
    $this->Cell(10, 8,"T FALT", 1, 1, 'C');

    $this->SetWidths(array(28,47,8,8,8,8,8,8,8,8,20,21,10));
    $this->SetAligns(Array('C','J','C','C','C','C','C','C','C','C','C','L','C'));

    $SumaTotal=0;
    for($i=0;$i<sizeof($nota);$i++){ 
    $array[] = $nota[$i]['definitiva'];
    $TotalDef=count($array);
    $SumaTotal+=$nota[$i]['definitiva'];

	$definitiva = ($nota[$i]['definitiva']);
	if($nota[$i]['definitiva'] == 0){
		$desempeno = "";
	} else if($nota[$i]['definitiva'] >= 0.1 && $nota[$i]['definitiva'] <= 2.9){
		$desempeno = "DES. BAJO";
	} else if($nota[$i]['definitiva'] >= 3.0 && $nota[$i]['definitiva'] <= 3.9){
		$desempeno = "DES. BSICO";
	} else if($nota[$i]['definitiva'] >= 4.0 && $nota[$i]['definitiva'] <= 4.9){
		$desempeno = "DES. ALTO";
	} else if($nota[$i]['definitiva'] >= 5.0){
		$desempeno = "DES. SUPERIOR";
	}

    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Row(array(
        portales(utf8_decode($nota[$i]['nomarea'])),
        portales(utf8_decode($nota[$i]['nommateria'])),
        utf8_decode($nota[$i]["nota1"]),
        utf8_decode($nota[$i]["faltas1"]),
        utf8_decode($nota[$i]["nota2"]),
        utf8_decode($nota[$i]["faltas2"]),
        utf8_decode($nota[$i]["nota3"]),
        utf8_decode($nota[$i]["faltas3"]),
        utf8_decode($nota[$i]["nota4"]),
        utf8_decode($nota[$i]["faltas4"]),
        portales(utf8_decode($definitiva)),
        portales($desempeno),
        portales($nota[$i]['total_faltas'])));
    }

    }//fin tipo de nivel

    //$this->Ln();
    $this->SetFont($TipoLetra,'B',8);
    $this->Cell(28, 14,"OBSERVACIONES", 1, 0, 'C');
    $this->SetFont($TipoLetra,'',11);
    $this->Cell(162, 14," ", 1, 1, 'L');

    $this->SetFont($TipoLetra,'B',9);
    $this->Cell(190, 6,portales("ESCALA DE VALORACIN: SUPERIOR: 5:00 - ALTO: 4.0 A 4.9 - BSICO: 3.0 A 3.9 -  BAJO: 1.0 A 2.9"), 1, 1, 'C');
    $this->Ln();

    $firma = (file_exists("./fotos/firma.png") == "" ? "./assets/images/null.png" : "./fotos/firma.png");
    $this->Image($firma, 150, 250, 30);

    $this->SetXY(10,264);
	$this->SetTextColor(3, 3, 3);  // Establece el color del texto (en este caso es blanco) 
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(85,6,'___________________________',0,0,'C');
    $this->Cell(20,6,'',0,0,'C');
    $this->Cell(85,6,'___________________________',0,0,'C');

    $this->SetXY(10,270);
    //$this->SetXY(10,-28);
	$this->SetTextColor(3, 3, 3);  // Establece el color del texto (en este caso es blanco) 
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(85,6,'DIRECTOR(A) GRADO',0,0,'C');
    $this->Cell(20,6,'',0,0,'C');
    $this->Cell(85,6,'RECTOR',0,1,'C');
}
############################# FUNCION PARA MOSTRAR BOLETIN POR PERIODOS #############################

###################################### FUNCION NOTAS DE ESTUDIANTES #####################################

 // FIN Class PDF
}
?>